/**
 * 
 */
package gov.va.med.fee.model.response;

import java.math.BigDecimal;
import java.sql.Timestamp;

import org.springframework.stereotype.Component;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Component
public class ClaimPaymentResponse {

	private String checkNumber;
    private Timestamp treasuryPaymentDateFormatted;
    private BigDecimal paidAmountFormatted;
	/**
	 * 
	 */
	public ClaimPaymentResponse() {
	}
	/**
	 * @param checkNumber
	 * @param treasuryPaymentDateFormatted
	 * @param paidAmountFormatted
	 */
	public ClaimPaymentResponse(String checkNumber, Timestamp treasuryPaymentDateFormatted, BigDecimal paidAmountFormatted) {
		super();
		this.checkNumber = checkNumber;
		this.treasuryPaymentDateFormatted = treasuryPaymentDateFormatted;
		this.paidAmountFormatted = paidAmountFormatted;
	}
	/**
	 * @return the checkNumber
	 */
	public String getCheckNumber() {
		return checkNumber;
	}
	/**
	 * @param checkNumber the checkNumber to set
	 */
	public void setCheckNumber(String checkNumber) {
		this.checkNumber = checkNumber;
	}
	/**
	 * @return the treasuryPaymentDateFormatted
	 */
	public Timestamp getTreasuryPaymentDateFormatted() {
		return treasuryPaymentDateFormatted;
	}
	/**
	 * @param treasuryPaymentDateFormatted the treasuryPaymentDateFormatted to set
	 */
	public void setTreasuryPaymentDateFormatted(Timestamp treasuryPaymentDateFormatted) {
		this.treasuryPaymentDateFormatted = treasuryPaymentDateFormatted;
	}
	/**
	 * @return the paidAmountFormatted
	 */
	public BigDecimal getPaidAmountFormatted() {
		return paidAmountFormatted;
	}
	/**
	 * @param paidAmountFormatted the paidAmountFormatted to set
	 */
	public void setPaidAmountFormatted(BigDecimal paidAmountFormatted) {
		this.paidAmountFormatted = paidAmountFormatted;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((checkNumber == null) ? 0 : checkNumber.hashCode());
		result = prime * result + ((paidAmountFormatted == null) ? 0 : paidAmountFormatted.hashCode());
		result = prime * result
				+ ((treasuryPaymentDateFormatted == null) ? 0 : treasuryPaymentDateFormatted.hashCode());
		return result;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ClaimPaymentResponse other = (ClaimPaymentResponse) obj;
		if (checkNumber == null) {
			if (other.checkNumber != null)
				return false;
		} else if (!checkNumber.equals(other.checkNumber))
			return false;
		if (paidAmountFormatted == null) {
			if (other.paidAmountFormatted != null)
				return false;
		} else if (!paidAmountFormatted.equals(other.paidAmountFormatted))
			return false;
		if (treasuryPaymentDateFormatted == null) {
			if (other.treasuryPaymentDateFormatted != null)
				return false;
		} else if (!treasuryPaymentDateFormatted.equals(other.treasuryPaymentDateFormatted))
			return false;
		return true;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ClaimPaymentResponse [checkNumber=");
		builder.append(checkNumber);
		builder.append(", treasuryPaymentDateFormatted=");
		builder.append(treasuryPaymentDateFormatted);
		builder.append(", paidAmountFormatted=");
		builder.append(paidAmountFormatted);
		builder.append("]");
		return builder.toString();
	}
     
}
