package gov.va.med.fee.model.response;

import java.util.List;

import org.springframework.stereotype.Component;

/**
 * @author Muneshwar Baiah
 * @author Vamsi Krishna Gangarapu
 *
 */

@Component
public class ClaimDetailsResponse {

	private long claimId;
	private String patientControlNumber;
	private String claimStatus;
	private String preAuthorization;
	// Need to be added to the constructor and the toString() method
	private String claimType;
	private String vaImpTypeCd;
	private VeteranInfoResponse veteranInfo;
	private ProviderInfoResponse serviceProviderInfo;
	private ProviderInfoResponse billingProviderInfo;
	private ProviderInfoResponse payToProviderInfo;
	private AdditionalInfoResponse additionalInfo;
	private List<DiagnosisCodes> diagnosisCodes;
	private List<LineItemResponse> lineItemsInfo;
	private List<ReRoutingHistory> reRoutingHistory;
	private List<ClaimRejectionHistoryResponse> rejectionHistory;
	private List<OhiInfoResponse> ohiInfo;
	
	// Add default constructor
	public ClaimDetailsResponse() {
		super();
	}

	// Add constructor w/ fields for testing
	public ClaimDetailsResponse(long claimId, String patientControlNumber, String claimStatus,
			String preAuthorization) {
		super();
		this.claimId = claimId;
		this.patientControlNumber = patientControlNumber;
		this.claimStatus = claimStatus;
		this.preAuthorization = preAuthorization;
	}

	public ClaimDetailsResponse(long claimId, String patientControlNumber, String claimStatus, String preAuthorization,
			VeteranInfoResponse veteranInfo, ProviderInfoResponse serviceProviderInfo,
			ProviderInfoResponse billingProviderInfo, ProviderInfoResponse payToProviderInfo,
			AdditionalInfoResponse additionalInfo, List<DiagnosisCodes> diagnosisCodes,
			List<LineItemResponse> lineItemsInfo, List<ReRoutingHistory> reRoutingHistory,
			List<ClaimRejectionHistoryResponse> rejectionHistory, List<OhiInfoResponse> ohiInfo) {
		super();
		this.claimId = claimId;
		this.patientControlNumber = patientControlNumber;
		this.claimStatus = claimStatus;
		this.preAuthorization = preAuthorization;
		this.veteranInfo = veteranInfo;
		this.serviceProviderInfo = serviceProviderInfo;
		this.billingProviderInfo = billingProviderInfo;
		this.payToProviderInfo = payToProviderInfo;
		this.additionalInfo = additionalInfo;
		this.diagnosisCodes = diagnosisCodes;
		this.lineItemsInfo = lineItemsInfo;
		this.reRoutingHistory = reRoutingHistory;
		this.rejectionHistory = rejectionHistory;
		this.ohiInfo = ohiInfo;
	}

	/**
	 * @return the vaImpTypeCd
	 */
	public String getVaImpTypeCd() {
		return vaImpTypeCd;
	}

	/**
	 * @param vaImpTypeCd the vaImpTypeCd to set
	 */
	public void setVaImpTypeCd(String vaImpTypeCd) {
		this.vaImpTypeCd = vaImpTypeCd;
	}

	/**
	 * @return the claimType
	 */
	public String getClaimType() {
		return claimType;
	}

	/**
	 * @param claimType the claimType to set
	 */
	public void setClaimType(String claimType) {
		this.claimType = claimType;
	}
	
	/**
	 * @return the claimId
	 */
	public long getClaimId() {
		return claimId;
	}

	/**
	 * @param claimId the claimId to set
	 */
	public void setClaimId(long claimId) {
		this.claimId = claimId;
	}

	/**
	 * @return the patientControlNumber
	 */
	public String getPatientControlNumber() {
		return patientControlNumber;
	}

	/**
	 * @param patientControlNumber the patientControlNumber to set
	 */
	public void setPatientControlNumber(String patientControlNumber) {
		this.patientControlNumber = patientControlNumber;
	}

	/**
	 * @return the claimStatus
	 */
	public String getClaimStatus() {
		return claimStatus;
	}

	/**
	 * @param claimStatus the claimStatus to set
	 */
	public void setClaimStatus(String claimStatus) {
		this.claimStatus = claimStatus;
	}

	/**
	 * @return the preAuthorization
	 */
	public String getPreAuthorization() {
		return preAuthorization;
	}

	/**
	 * @param preAuthorization the preAuthorization to set
	 */
	public void setPreAuthorization(String preAuthorization) {
		this.preAuthorization = preAuthorization;
	}

	/**
	 * @return the veteranInfo
	 */
	public VeteranInfoResponse getVeteranInfo() {
		return veteranInfo;
	}

	/**
	 * @param veteranInfo the veteranInfo to set
	 */
	public void setVeteranInfo(VeteranInfoResponse veteranInfo) {
		this.veteranInfo = veteranInfo;
	}

	/**
	 * @return the serviceProviderInfo
	 */
	public ProviderInfoResponse getServiceProviderInfo() {
		return serviceProviderInfo;
	}

	/**
	 * @param serviceProviderInfo the serviceProviderInfo to set
	 */
	public void setServiceProviderInfo(ProviderInfoResponse serviceProviderInfo) {
		this.serviceProviderInfo = serviceProviderInfo;
	}

	/**
	 * @return the billingProviderInfo
	 */
	public ProviderInfoResponse getBillingProviderInfo() {
		return billingProviderInfo;
	}

	/**
	 * @param billingProviderInfo the billingProviderInfo to set
	 */
	public void setBillingProviderInfo(ProviderInfoResponse billingProviderInfo) {
		this.billingProviderInfo = billingProviderInfo;
	}

	/**
	 * @return the payToProviderInfo
	 */
	public ProviderInfoResponse getPayToProviderInfo() {
		return payToProviderInfo;
	}

	/**
	 * @param payToProviderInfo the payToProviderInfo to set
	 */
	public void setPayToProviderInfo(ProviderInfoResponse payToProviderInfo) {
		this.payToProviderInfo = payToProviderInfo;
	}

	/**
	 * @return the additionalInfo
	 */
	public AdditionalInfoResponse getAdditionalInfo() {
		return additionalInfo;
	}

	/**
	 * @param additionalInfo the additionalInfo to set
	 */
	public void setAdditionalInfo(AdditionalInfoResponse additionalInfo) {
		this.additionalInfo = additionalInfo;
	}

	/**
	 * @return the diagnosisCodes
	 */
	public List<DiagnosisCodes> getDiagnosisCodes() {
		return diagnosisCodes;
	}

	/**
	 * @param diagnosisCodes the diagnosisCodes to set
	 */
	public void setDiagnosisCodes(List<DiagnosisCodes> diagnosisCodes) {
		this.diagnosisCodes = diagnosisCodes;
	}

	/**
	 * @return the lineItemsInfo
	 */
	public List<LineItemResponse> getLineItemsInfo() {
		return lineItemsInfo;
	}

	/**
	 * @param lineItemsInfo the lineItemsInfo to set
	 */
	public void setLineItemsInfo(List<LineItemResponse> lineItemsInfo) {
		this.lineItemsInfo = lineItemsInfo;
	}

	/**
	 * @return the reRoutingHistory
	 */
	public List<ReRoutingHistory> getReRoutingHistory() {
		return reRoutingHistory;
	}

	/**
	 * @param reRoutingHistory the reRoutingHistory to set
	 */
	public void setReRoutingHistory(List<ReRoutingHistory> reRoutingHistory) {
		this.reRoutingHistory = reRoutingHistory;
	}

	/**
	 * @return the rejectionHistory
	 */
	public List<ClaimRejectionHistoryResponse> getRejectionHistory() {
		return rejectionHistory;
	}

	/**
	 * @param rejectionHistory the rejectionHistory to set
	 */
	public void setRejectionHistory(List<ClaimRejectionHistoryResponse> rejectionHistory) {
		this.rejectionHistory = rejectionHistory;
	}
	
	public List<OhiInfoResponse> getOhiInfo() {
		return ohiInfo;
	}

	public void setOhiInfo(List<OhiInfoResponse> ohiInfo) {
		this.ohiInfo = ohiInfo;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((additionalInfo == null) ? 0 : additionalInfo.hashCode());
		result = prime * result + ((billingProviderInfo == null) ? 0 : billingProviderInfo.hashCode());
		result = prime * result + (int) (claimId ^ (claimId >>> 32));
		result = prime * result + ((claimStatus == null) ? 0 : claimStatus.hashCode());
		result = prime * result + ((claimType == null) ? 0 : claimType.hashCode());
		result = prime * result + ((diagnosisCodes == null) ? 0 : diagnosisCodes.hashCode());
		result = prime * result + ((lineItemsInfo == null) ? 0 : lineItemsInfo.hashCode());
		result = prime * result + ((ohiInfo == null) ? 0 : ohiInfo.hashCode());
		result = prime * result + ((patientControlNumber == null) ? 0 : patientControlNumber.hashCode());
		result = prime * result + ((payToProviderInfo == null) ? 0 : payToProviderInfo.hashCode());
		result = prime * result + ((preAuthorization == null) ? 0 : preAuthorization.hashCode());
		result = prime * result + ((reRoutingHistory == null) ? 0 : reRoutingHistory.hashCode());
		result = prime * result + ((rejectionHistory == null) ? 0 : rejectionHistory.hashCode());
		result = prime * result + ((serviceProviderInfo == null) ? 0 : serviceProviderInfo.hashCode());
		result = prime * result + ((vaImpTypeCd == null) ? 0 : vaImpTypeCd.hashCode());
		result = prime * result + ((veteranInfo == null) ? 0 : veteranInfo.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ClaimDetailsResponse other = (ClaimDetailsResponse) obj;
		if (additionalInfo == null) {
			if (other.additionalInfo != null)
				return false;
		} else if (!additionalInfo.equals(other.additionalInfo))
			return false;
		if (billingProviderInfo == null) {
			if (other.billingProviderInfo != null)
				return false;
		} else if (!billingProviderInfo.equals(other.billingProviderInfo))
			return false;
		if (claimId != other.claimId)
			return false;
		if (claimStatus == null) {
			if (other.claimStatus != null)
				return false;
		} else if (!claimStatus.equals(other.claimStatus))
			return false;
		if (claimType == null) {
			if (other.claimType != null)
				return false;
		} else if (!claimType.equals(other.claimType))
			return false;
		if (diagnosisCodes == null) {
			if (other.diagnosisCodes != null)
				return false;
		} else if (!diagnosisCodes.equals(other.diagnosisCodes))
			return false;
		if (lineItemsInfo == null) {
			if (other.lineItemsInfo != null)
				return false;
		} else if (!lineItemsInfo.equals(other.lineItemsInfo))
			return false;
		if (ohiInfo == null) {
			if (other.ohiInfo != null)
				return false;
		} else if (!ohiInfo.equals(other.ohiInfo))
			return false;
		if (patientControlNumber == null) {
			if (other.patientControlNumber != null)
				return false;
		} else if (!patientControlNumber.equals(other.patientControlNumber))
			return false;
		if (payToProviderInfo == null) {
			if (other.payToProviderInfo != null)
				return false;
		} else if (!payToProviderInfo.equals(other.payToProviderInfo))
			return false;
		if (preAuthorization == null) {
			if (other.preAuthorization != null)
				return false;
		} else if (!preAuthorization.equals(other.preAuthorization))
			return false;
		if (reRoutingHistory == null) {
			if (other.reRoutingHistory != null)
				return false;
		} else if (!reRoutingHistory.equals(other.reRoutingHistory))
			return false;
		if (rejectionHistory == null) {
			if (other.rejectionHistory != null)
				return false;
		} else if (!rejectionHistory.equals(other.rejectionHistory))
			return false;
		if (serviceProviderInfo == null) {
			if (other.serviceProviderInfo != null)
				return false;
		} else if (!serviceProviderInfo.equals(other.serviceProviderInfo))
			return false;
		if (vaImpTypeCd == null) {
			if (other.vaImpTypeCd != null)
				return false;
		} else if (!vaImpTypeCd.equals(other.vaImpTypeCd))
			return false;
		if (veteranInfo == null) {
			if (other.veteranInfo != null)
				return false;
		} else if (!veteranInfo.equals(other.veteranInfo))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ClaimDetailsResponse [claimId=");
		builder.append(claimId);
		builder.append(", patientControlNumber=");
		builder.append(patientControlNumber);
		builder.append(", claimStatus=");
		builder.append(claimStatus);
		builder.append(", preAuthorization=");
		builder.append(preAuthorization);
		builder.append(", veteranInfo=");
		builder.append(veteranInfo);
		builder.append(", serviceProviderInfo=");
		builder.append(serviceProviderInfo);
		builder.append(", billingProviderInfo=");
		builder.append(billingProviderInfo);
		builder.append(", payToProviderInfo=");
		builder.append(payToProviderInfo);
		builder.append(", additionalInfo=");
		builder.append(additionalInfo);
		builder.append(", diagnosisCodes=");
		builder.append(diagnosisCodes);
		builder.append(", lineItemsInfo=");
		builder.append(lineItemsInfo);
		builder.append(", reRoutingHistory=");
		builder.append(reRoutingHistory);
		builder.append(", rejectionHistory=");
		builder.append(rejectionHistory);
		builder.append(", ohiInfo=");
		builder.append(ohiInfo);
		builder.append("]");
		return builder.toString();
	}	
}
