package gov.va.med.fee.model.request;

import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonInclude;

public class ZipCodeRequest {

	@JsonInclude(JsonInclude.Include.NON_NULL)
	@NotNull
	private String appUserName;
	@NotNull
	@Size(min=1, max=12)
    private String vaFacilityCd;
    @NotNull
    @Size(min=1, max=5, message="Zip code max length is 5")
    private String zip_code;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @Size(min=0, max=10, message="Urban indicatore max length is 10")
    private String urban_indicator;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @Size(min=0, max=3)
    private String fips_county_code;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @Size(min=0, max=2)
    private String fips_state_code;
    private Boolean active = Boolean.TRUE;    
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String created_by;    
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String date_created;  
	
    
    public ZipCodeRequest() {
		super();
	}
        
	public ZipCodeRequest(String vaFacilityCd, String zip_code, String urban_indicator, String fips_county_code,
			String fips_state_code, Boolean active, String created_by, String date_created) {
		super();
		this.vaFacilityCd = vaFacilityCd;
		this.zip_code = zip_code;
		this.urban_indicator = urban_indicator;
		this.fips_county_code = fips_county_code;
		this.fips_state_code = fips_state_code;
		this.created_by = created_by;
		this.date_created = date_created;
		this.active = active;
	}

	public ZipCodeRequest(String appUserName, String vaFacilityCd, String zip_code, String urban_indicator,
			String fips_county_code, String fips_state_code, boolean active) {
		super();
		this.appUserName = appUserName;
		this.vaFacilityCd = vaFacilityCd;
		this.zip_code = zip_code;
		this.urban_indicator = urban_indicator;
		this.fips_county_code = fips_county_code;
		this.fips_state_code = fips_state_code;
		this.active = active;
	}

	/**
	 * @return the appUserName
	 */
	public String getAppUserName() {
		return appUserName;
	}

	/**
	 * @param appUserName the appUserName to set
	 */
	public void setAppUserName(String appUserName) {
		this.appUserName = appUserName;
	}

	/**
	 * @return the vaFacilityCd
	 */
	public String getVaFacilityCd() {
		return vaFacilityCd;
	}

	/**
	 * @param vaFacilityCd the vaFacilityCd to set
	 */
	public void setVaFacilityCd(String vaFacilityCd) {
		this.vaFacilityCd = vaFacilityCd;
	}

	/**
	 * @return the zip_code
	 */
	public String getZip_code() {
		return zip_code;
	}

	/**
	 * @param zip_code the zip_code to set
	 */
	public void setZip_code(String zip_code) {
		this.zip_code = zip_code;
	}

	/**
	 * @return the urban_indicator
	 */
	public String getUrban_indicator() {
		return urban_indicator;
	}

	/**
	 * @param urban_indicator the urban_indicator to set
	 */
	public void setUrban_indicator(String urban_indicator) {
		this.urban_indicator = urban_indicator;
	}

	/**
	 * @return the fips_county_code
	 */
	public String getFips_county_code() {
		return fips_county_code;
	}

	/**
	 * @param fips_county_code the fips_county_code to set
	 */
	public void setFips_county_code(String fips_county_code) {
		this.fips_county_code = fips_county_code;
	}

	/**
	 * @return the fips_state_code
	 */
	public String getFips_state_code() {
		return fips_state_code;
	}

	/**
	 * @param fips_state_code the fips_state_code to set
	 */
	public void setFips_state_code(String fips_state_code) {
		this.fips_state_code = fips_state_code;
	}

	/**
	 * @return the active
	 */
	public Boolean getActive() {
		return active;
	}

	/**
	 * @param active the active to set
	 */
	public void setActive(Boolean active) {
		this.active = active;
	}
	
	/**
	 * @return the created_by
	 */
	public String getCreated_by() {
		return created_by;
	}

	/**
	 * @param created_by the created_by to set
	 */
	public void setCreated_by(String created_by) {
		this.created_by = created_by;
	}

	/**
	 * @return the date_created
	 */
	public String getDate_created() {
		return date_created;
	}

	/**
	 * @param date_created the date_created to set
	 */
	public void setDate_created(String date_created) {
		this.date_created = date_created;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((active == null) ? 0 : active.hashCode());
		result = prime * result + ((appUserName == null) ? 0 : appUserName.hashCode());
		result = prime * result + ((created_by == null) ? 0 : created_by.hashCode());
		result = prime * result + ((date_created == null) ? 0 : date_created.hashCode());
		result = prime * result + ((fips_county_code == null) ? 0 : fips_county_code.hashCode());
		result = prime * result + ((fips_state_code == null) ? 0 : fips_state_code.hashCode());
		result = prime * result + ((urban_indicator == null) ? 0 : urban_indicator.hashCode());
		result = prime * result + ((vaFacilityCd == null) ? 0 : vaFacilityCd.hashCode());
		result = prime * result + ((zip_code == null) ? 0 : zip_code.hashCode());
		return result;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ZipCodeRequest other = (ZipCodeRequest) obj;
		if (active == null) {
			if (other.active != null)
				return false;
		} else if (!active.equals(other.active))
			return false;
		if (appUserName == null) {
			if (other.appUserName != null)
				return false;
		} else if (!appUserName.equals(other.appUserName))
			return false;
		if (created_by == null) {
			if (other.created_by != null)
				return false;
		} else if (!created_by.equals(other.created_by))
			return false;
		if (date_created == null) {
			if (other.date_created != null)
				return false;
		} else if (!date_created.equals(other.date_created))
			return false;
		if (fips_county_code == null) {
			if (other.fips_county_code != null)
				return false;
		} else if (!fips_county_code.equals(other.fips_county_code))
			return false;
		if (fips_state_code == null) {
			if (other.fips_state_code != null)
				return false;
		} else if (!fips_state_code.equals(other.fips_state_code))
			return false;
		if (urban_indicator == null) {
			if (other.urban_indicator != null)
				return false;
		} else if (!urban_indicator.equals(other.urban_indicator))
			return false;
		if (vaFacilityCd == null) {
			if (other.vaFacilityCd != null)
				return false;
		} else if (!vaFacilityCd.equals(other.vaFacilityCd))
			return false;
		if (zip_code == null) {
			if (other.zip_code != null)
				return false;
		} else if (!zip_code.equals(other.zip_code))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ZipCodeRequest [appUserName=" + appUserName + ", vaFacilityCd=" + vaFacilityCd + ", zip_code="
				+ zip_code + ", urban_indicator=" + urban_indicator + ", fips_county_code=" + fips_county_code
				+ ", fips_state_code=" + fips_state_code + ", created_by=" + created_by + ", date_created="
				+ date_created + ", active=" + active + "]";
	}
	
}
