package gov.va.med.fee.model.request;

import java.util.List;

public class UserReqRequest {

	private String current_user_name;
	private String window_nt_name;
	private String last_name;
	private String first_name;
	private String middle_name;
	private String phone;
	private String email;
	private Boolean enabled;
	private int request_type;
	private List<String> request_roles;  //Request These Roles
	private List<String> request_facilities; //Request These Facilities
	
	private String disable_comments; //Disable Comments
	private String requestedRoles;
	private String requestedFacilities;
	
	public UserReqRequest() {
		super();
	}
	
	//Create User Request
	public UserReqRequest(String current_user_name, String window_nt_name, String last_name, String first_name, String middle_name,
			String phone, String email, boolean enabled, List<String> request_roles, List<String> request_facilities) {
		super();
		this.current_user_name = current_user_name;
		this.window_nt_name = window_nt_name;
		this.last_name = last_name;
		this.first_name = first_name;
		this.middle_name = middle_name;
		this.phone = phone;
		this.email = email;
		this.enabled = enabled;
		this.request_roles = request_roles;
		this.request_facilities = request_facilities;		
	}
	
	//Modify User Request
	public UserReqRequest(String current_user_name, String window_nt_name, String last_name, String first_name, String middle_name,
			String phone, String email, boolean enabled, List<String> request_roles, List<String> request_facilities,
			String disable_comments) {
		super();
		this.current_user_name = current_user_name;
		this.window_nt_name = window_nt_name;
		this.last_name = last_name;
		this.first_name = first_name;
		this.middle_name = middle_name;
		this.phone = phone;
		this.email = email;
		this.enabled = enabled;
		this.request_roles = request_roles;
		this.request_facilities = request_facilities;
		this.disable_comments = disable_comments;
	}
	
	/**
	 * @return the current_user_name
	 */
	public String getCurrent_user_name() {
		return current_user_name;
	}

	/**
	 * @param current_user_name the current_user_name to set
	 */
	public void setCurrent_user_name(String current_user_name) {
		this.current_user_name = current_user_name;
	}
		
	/**
	 * @return the window_nt_name
	 */
	public String getWindow_nt_name() {
		return window_nt_name.trim().toUpperCase();
	}

	/**
	 * @param window_nt_name the window_nt_name to set
	 */
	public void setWindow_nt_name(String window_nt_name) {
		this.window_nt_name = window_nt_name;
	}

	/**
	 * @return the last_name
	 */
	public String getLast_name() {
		return last_name.trim().toUpperCase();
	}

	/**
	 * @param last_name the last_name to set
	 */
	public void setLast_name(String last_name) {
		this.last_name = last_name;
	}

	/**
	 * @return the first_name
	 */
	public String getFirst_name() {
		if(first_name != null){
			first_name = first_name.trim().toUpperCase();
		}
		return first_name;
	}

	/**
	 * @param first_name the first_name to set
	 */
	public void setFirst_name(String first_name) {
		this.first_name = first_name;
	}

	/**
	 * @return the middle_name
	 */
	public String getMiddle_name() {
		if(middle_name != null){
			middle_name = middle_name.trim().toUpperCase();
		}
		return middle_name;
	}

	/**
	 * @param middle_name the middle_name to set
	 */
	public void setMiddle_name(String middle_name) {
		this.middle_name = middle_name;
	}

	/**
	 * @return the phone
	 */
	public String getPhone() {
		return phone;
	}

	/**
	 * @param phone the phone to set
	 */
	public void setPhone(String phone) {
		this.phone = phone;
	}

	/**
	 * @return the email
	 */
	public String getEmail() {
		if(email != null){
			email = email.trim().toUpperCase();
		}
		return email;
	}

	/**
	 * @param email the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the enabled
	 */
	public boolean getEnabled() {
		return enabled;
	}

	/**
	 * @param enabled the enabled to set
	 */
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	/**
	 * @return the request_type
	 */
	public int getRequest_type() {
		return request_type;
	}

	/**
	 * @param request_type the request_type to set
	 */
	public void setRequest_type(int request_type) {
		this.request_type = request_type;
	}

	/**
	 * @return the request_roles
	 */
	public List<String> getRequest_roles() {
		return request_roles;
	}

	/**
	 * @param request_roles the request_roles to set
	 */
	public void setRequest_roles(List<String> request_roles) {
		this.request_roles = request_roles;
	}

	/**
	 * @return the request_facilities
	 */
	public List<String> getRequest_facilities() {
		return request_facilities;
	}

	/**
	 * @param request_facilities the request_facilities to set
	 */
	public void setRequest_facilities(List<String> request_facilities) {
		this.request_facilities = request_facilities;
	}

	/**
	 * @return the disable_comments
	 */
	public String getDisable_comments() {
		return disable_comments;
	}

	/**
	 * @param disable_comments the disable_comments to set
	 */
	public void setDisable_comments(String disable_comments) {
		this.disable_comments = disable_comments;
	}

	/**
	 * @return the requestedRoles
	 */
	public String getRequestedRoles() {
		StringBuilder requestedRoles = new StringBuilder();
		String comma = "";
		if(request_roles != null) {
			for (String role : request_roles) {
				requestedRoles.append(comma).append(role); //+= comma + role;
				comma = ", ";
			}
		}
		return requestedRoles.toString();
	}

	/**
	 * @param requestedRoles the requestedRoles to set
	 */
	public void setRequestedRoles(String requestedRoles) {
		this.requestedRoles = requestedRoles;
	}

	/**
	 * @return the requestedFacilities
	 */
	public String getRequestedFacilities() {
		StringBuilder requestedFacilities = new StringBuilder();
		String comma = "";
		if(request_facilities != null) {
			for (String fac : request_facilities) {
				requestedFacilities.append(comma).append(fac); // +=comma+fac;
				comma = ", ";
			}
		}
		return requestedFacilities.toString();
	}

	/**
	 * @param requestedFacilities the requestedFacilities to set
	 */
	public void setRequestedFacilities(String requestedFacilities) {
		this.requestedFacilities = requestedFacilities;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "UserReqRequest [current_user_name=" + current_user_name + ", window_nt_name=" + window_nt_name
				+ ", last_name=" + last_name + ", first_name=" + first_name + ", middle_name=" + middle_name
				+ ", phone=" + phone + ", email=" + email + ", enabled=" + enabled + ", request_roles=" + request_roles
				+ ", request_facilities=" + request_facilities + ", disable_comments=" + disable_comments
				+ ", requestedRoles=" + requestedRoles + ", requestedFacilities=" + requestedFacilities + "]";
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((current_user_name == null) ? 0 : current_user_name.hashCode());
		result = prime * result + ((disable_comments == null) ? 0 : disable_comments.hashCode());
		result = prime * result + ((email == null) ? 0 : email.hashCode());
		result = prime * result + ((enabled == null) ? 0 : enabled.hashCode());
		result = prime * result + ((first_name == null) ? 0 : first_name.hashCode());
		result = prime * result + ((last_name == null) ? 0 : last_name.hashCode());
		result = prime * result + ((middle_name == null) ? 0 : middle_name.hashCode());
		result = prime * result + ((phone == null) ? 0 : phone.hashCode());
		result = prime * result + ((request_facilities == null) ? 0 : request_facilities.hashCode());
		result = prime * result + ((request_roles == null) ? 0 : request_roles.hashCode());
		result = prime * result + request_type;
		result = prime * result + ((window_nt_name == null) ? 0 : window_nt_name.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UserReqRequest other = (UserReqRequest) obj;
		if (current_user_name == null) {
			if (other.current_user_name != null)
				return false;
		} else if (!current_user_name.equals(other.current_user_name))
			return false;
		if (disable_comments == null) {
			if (other.disable_comments != null)
				return false;
		} else if (!disable_comments.equals(other.disable_comments))
			return false;
		if (email == null) {
			if (other.email != null)
				return false;
		} else if (!email.equals(other.email))
			return false;
		if (enabled == null) {
			if (other.enabled != null)
				return false;
		} else if (!enabled.equals(other.enabled))
			return false;
		if (first_name == null) {
			if (other.first_name != null)
				return false;
		} else if (!first_name.equals(other.first_name))
			return false;
		if (last_name == null) {
			if (other.last_name != null)
				return false;
		} else if (!last_name.equals(other.last_name))
			return false;
		if (middle_name == null) {
			if (other.middle_name != null)
				return false;
		} else if (!middle_name.equals(other.middle_name))
			return false;
		if (phone == null) {
			if (other.phone != null)
				return false;
		} else if (!phone.equals(other.phone))
			return false;
		if (request_facilities == null) {
			if (other.request_facilities != null)
				return false;
		} else if (!request_facilities.equals(other.request_facilities))
			return false;
		if (request_roles == null) {
			if (other.request_roles != null)
				return false;
		} else if (!request_roles.equals(other.request_roles))
			return false;
		if (request_type != other.request_type)
			return false;
		if (window_nt_name == null) {
			if (other.window_nt_name != null)
				return false;
		} else if (!window_nt_name.equals(other.window_nt_name))
			return false;
		return true;
	}
	
	
}
