package gov.va.med.fee.model.request;

import java.util.List;

import gov.va.med.domain.fee.AppRole;
import gov.va.med.domain.fee.AppUser;
import gov.va.med.domain.fee.VaFacility;

public class UserAdminRequest {

	private AppUser userToCreate;
	private Boolean userToCreateEnabled;
	private List<AppRole> rolesAvailableToUser;
	private List<AppRole> rolesAvailableToUserForUserModifyRequest;
	private List<VaFacility> facilitiesAvailableToUser;
	
	public UserAdminRequest() {
		super();
	}

	public UserAdminRequest(AppUser userToCreate, Boolean userToCreateEnabled, List<AppRole> rolesAvailableToUser,
			List<AppRole> rolesAvailableToUserForUserModifyRequest, List<VaFacility> facilitiesAvailableToUser) {
		super();
		this.userToCreate = userToCreate;
		this.userToCreateEnabled = userToCreateEnabled;
		this.rolesAvailableToUser = rolesAvailableToUser;
		this.rolesAvailableToUserForUserModifyRequest = rolesAvailableToUserForUserModifyRequest;
		this.facilitiesAvailableToUser = facilitiesAvailableToUser;
	}

	/**
	 * @return the userToCreate
	 */
	public AppUser getUserToCreate() {
		return userToCreate;
	}

	/**
	 * @param userToCreate the userToCreate to set
	 */
	public void setUserToCreate(AppUser userToCreate) {
		this.userToCreate = userToCreate;
	}

	/**
	 * @return the userToCreateEnabled
	 */
	public Boolean getUserToCreateEnabled() {
		return userToCreateEnabled;
	}

	/**
	 * @param userToCreateEnabled the userToCreateEnabled to set
	 */
	public void setUserToCreateEnabled(Boolean userToCreateEnabled) {
		this.userToCreateEnabled = userToCreateEnabled;
	}

	/**
	 * @return the rolesAvailableToUser
	 */
	public List<AppRole> getRolesAvailableToUser() {
		return rolesAvailableToUser;
	}

	/**
	 * @param rolesAvailableToUser the rolesAvailableToUser to set
	 */
	public void setRolesAvailableToUser(List<AppRole> rolesAvailableToUser) {
		this.rolesAvailableToUser = rolesAvailableToUser;
	}

	/**
	 * @return the rolesAvailableToUserForUserModifyRequest
	 */
	public List<AppRole> getRolesAvailableToUserForUserModifyRequest() {
		return rolesAvailableToUserForUserModifyRequest;
	}

	/**
	 * @param rolesAvailableToUserForUserModifyRequest the rolesAvailableToUserForUserModifyRequest to set
	 */
	public void setRolesAvailableToUserForUserModifyRequest(List<AppRole> rolesAvailableToUserForUserModifyRequest) {
		this.rolesAvailableToUserForUserModifyRequest = rolesAvailableToUserForUserModifyRequest;
	}

	/**
	 * @return the facilitiesAvailableToUser
	 */
	public List<VaFacility> getFacilitiesAvailableToUser() {
		return facilitiesAvailableToUser;
	}

	/**
	 * @param facilitiesAvailableToUser the facilitiesAvailableToUser to set
	 */
	public void setFacilitiesAvailableToUser(List<VaFacility> facilitiesAvailableToUser) {
		this.facilitiesAvailableToUser = facilitiesAvailableToUser;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "UserAdminRequest [userToCreate=" + userToCreate + ", userToCreateEnabled=" + userToCreateEnabled
				+ ", rolesAvailableToUser=" + rolesAvailableToUser + ", rolesAvailableToUserForUserModifyRequest="
				+ rolesAvailableToUserForUserModifyRequest + ", facilitiesAvailableToUser=" + facilitiesAvailableToUser
				+ "]";
	}
	
}
