package gov.va.med.fee.model.request;

public class StationRequest {

	private String vaFacilityCd;
	private long visnIdCd;
	private String shortName;
	private String displayFacility;
	
	public StationRequest() {
		super();
	}

	public StationRequest(String vaFacilityCd, long visnIdCd, String shortName) {
		super();
		this.vaFacilityCd = vaFacilityCd;
		this.visnIdCd = visnIdCd;
		this.shortName = shortName;
	}

	/**
	 * @return the vaFacilityCd
	 */
	public String getVaFacilityCd() {
		return vaFacilityCd;
	}

	/**
	 * @param vaFacilityCd the vaFacilityCd to set
	 */
	public void setVaFacilityCd(String vaFacilityCd) {
		this.vaFacilityCd = vaFacilityCd;
	}

	/**
	 * @return the visnIdCd
	 */
	public long getVisnIdCd() {
		return visnIdCd;
	}

	/**
	 * @param visnIdCd the visnIdCd to set
	 */
	public void setVisnIdCd(long visnIdCd) {
		this.visnIdCd = visnIdCd;
	}

	/**
	 * @return the shortName
	 */
	public String getShortName() {
		return shortName;
	}

	/**
	 * @param shortName the shortName to set
	 */
	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	/**
	 * @return the displayFacility
	 */
	public String getDisplayFacility() {
		String displayShortName = shortName != null ? " ("  + shortName + ")" : "";
		displayFacility = "Visn: " + String.valueOf(visnIdCd) + " / Facility: " + vaFacilityCd + displayShortName;
		return displayFacility;
	}

	/**
	 * @param displayFacility the displayFacility to set
	 */
	public void setDisplayFacility(String displayFacility) {
		this.displayFacility = displayFacility;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "StationRequest [vaFacilityCd=" + vaFacilityCd + ", visnIdCd=" + visnIdCd + ", shortName=" + shortName
				+ ", displayFacility=" + displayFacility + "]";
	}
}
