/*
 * $Id: Criteria.java,v 1.8 2010/01/07 14:50:31 vhahacnguyes Exp $
 */
package gov.va.med.fee.model.request;

import java.util.Arrays;

import gov.va.med.fee.report.DateValue;
import gov.va.med.fee.report.ReportNumber;

//import org.hibernate.validator.Max;


/**
 * Holds filter criteria.
 */
public class SearchCriteriaRequest {

    /** The Constant MAX_NUM_RESULTS. */
    private static final int MAX_NUM_RESULTS = 60000;

    /** The Constant DEFAULT_NUM_RESULTS. */
    private static final int DEFAULT_NUM_RESULTS = 1000;

    /** The facilities. */
    private String[] facilities;

    /** The format. */
    private String format;

    /** The from facilities. */
    private String[] fromFacilities;

    /** The num results. */
   // @Min(0)
   // @Max(MAX_NUM_RESULTS)
    private Integer numResults;

    /** Includes the VISN claims or not. */
    private int visnClaims;

    /** The project. */
    private int project;

    /** The reasons. */
    private String[] reasons;

    /** The report. */
    private String report;

    /** The report name. */
    private String reportName;

    /** The report types. */
    private String[] reportTypes;

    /** The service codes. */
    private String[] serviceCodes;

    /** The sort by. */
    private int sortBy;

    /** The to facilities. */
    private String[] toFacilities;

    /** The trans codes. */
    private String[] transCodes;

    /** The date value. */
    private DateValue dateValue = new DateValue();

    /**
     * Creates a new instance of Criteria.
     */
    public SearchCriteriaRequest() {
    }

    /**
     * Reset.
     */
    public final void reset() {
        facilities = null;
        format = "P";
        fromFacilities = null;
        numResults = DEFAULT_NUM_RESULTS;
        project = 0;
        visnClaims = 0;
        reasons = null;
        reportTypes = null;
        serviceCodes = null;
        sortBy = 0;
        toFacilities = null;
        transCodes = null;

        dateValue.reset();
    }

    /**
     * Checks if is valid.
     *
     * @return true, if is valid
     */
    public final boolean isValid() {
        // the only one does not require date
        if (ReportNumber.OUT_OF_SYSTEM_SUM == getReportNumber()) {
            return true;
        }

        return dateValue.isValid();
    }

    /**
     * Gets the visn claims.
     *
     * @return the visn claims
     */
    public int getVisnClaims() {
        return visnClaims;
    }

    /**
     * Sets the visn claims.
     *
     * @param visnClaims the new visn claims
     */
    public void setVisnClaims(int visnClaims) {
        this.visnClaims = visnClaims;
    }

    /**
     * Gets the facilities.
     *
     * @return the facilities
     */
    public final String[] getFacilities() {
        return facilities;
    }

    /**
     * Getter for property format.
     *
     * @return Value of property format.
     */
    public final String getFormat() {
        return this.format;
    }

    /**
     * Getter for property fromFacilities.
     *
     * @return Value of property fromFacilities.
     */
    public final String[] getFromFacilities() {
        return this.fromFacilities;
    }

    /**
     * Gets the num results.
     *
     * @return the num results
     */
    public final Integer getNumResults() {
        return numResults;
    }

    /**
     * Gets the project.
     *
     * @return the project choice
     */
    public final int getProject() {
        return project;
    }

    /**
     * Getter for property reasons.
     *
     * @return Value of property reasons.
     */
    public final String[] getReasons() {
        return this.reasons;
    }

    /**
     * Getter for property report.
     *
     * @return Value of property report.
     */
    public final String getReport() {
        return this.report;
    }

    /**
     * Gets the report number.
     *
     * @return the report number
     */
    public final int getReportNumber() {
        return Integer.parseInt(report);
    }

    /**
     * Getter for property reportType.
     *
     * @return Value of property reportType.
     */
    public final String[] getReportTypes() {
        return this.reportTypes;
    }

    /**
     * Getter for property serviceCodes.
     *
     * @return Value of property serviceCodes.
     */
    public final String[] getServiceCodes() {
        return this.serviceCodes;
    }

    /**
     * Getter for property sortBy.
     *
     * @return Value of property sortBy.
     */
    public final int getSortBy() {
        return this.sortBy;
    }

    /**
     * Getter for property toFacilities.
     *
     * @return Value of property toFacilities.
     */
    public final String[] getToFacilities() {
        return this.toFacilities;
    }

    /**
     * Getter for property transCodes.
     *
     * @return Value of property transCodes.
     */
    public final String[] getTransCodes() {
        return this.transCodes;
    }

    /**
     * Sets the facilities.
     *
     * @param facilities the new facilities
     */
    public final void setFacilities(final String[] facilities) {
        this.facilities = facilities;
    }

    /**
     * Setter for property format.
     *
     * @param format New value of property format.
     */
    public final void setFormat(final String format) {
        this.format = format;
    }

    /**
     * Setter for property fromFacilities.
     *
     * @param fromFacilities the from facilities
     */
    public final void setFromFacilities(final String[] fromFacilities) {
        this.fromFacilities = fromFacilities;
    }

    /**
     * Setter for property limit.
     *
     * @param numResults the num results
     */
    public final void setNumResults(final Integer numResults) {
        this.numResults = numResults;
    }

    /**
     * Sets the project choice.
     *
     * @param project the project
     */
    public final void setProject(final int project) {
        this.project = project;
    }

    /**
     * Setter for property reasons.
     *
     * @param reasons the reasons
     */
    public final void setReasons(final String[] reasons) {
        this.reasons = reasons;
    }

    /**
     * Setter for property report.
     *
     * @param report New value of property report.
     */
    public final void setReport(final String report) {
        this.report = report;
    }

    /**
     * Setter for property reportType.
     *
     * @param reportTypes the report types
     */
    public final void setReportTypes(final String[] reportTypes) {
        this.reportTypes = reportTypes;
    }

    /**
     * Setter for property serviceCodes.
     *
     * @param serviceCodes New value of property serviceCodes.
     */
    public final void setServiceCodes(final String[] serviceCodes) {
        this.serviceCodes = serviceCodes;
    }

    /**
     * Setter for property sortBy.
     *
     * @param sortBy New value of property sortBy.
     */
    public final void setSortBy(final int sortBy) {
        this.sortBy = sortBy;
    }

    /**
     * Setter for property toFacilities.
     *
     * @param toFacilities the to facilities
     */
    public final void setToFacilities(final String[] toFacilities) {
        this.toFacilities = toFacilities;
    }

    /**
     * Setter for property transCodes.
     *
     * @param transCodes New value of property transCodes.
     */
    public final void setTransCodes(final String[] transCodes) {
        this.transCodes = transCodes;
    }

    /**
     * Gets the report name.
     *
     * @return the report name
     */
    public final String getReportName() {
        return reportName;
    }

    /**
     * Sets the report name.
     *
     * @param reportName the new report name
     */
    public final void setReportName(final String reportName) {
        this.reportName = reportName;
    }

    /**
     * Gets the date value.
     *
     * @return the date value
     */
    //@ReportDate
    public final DateValue getDateValue() {
        return dateValue;
    }

    /**
     * Sets the date value.
     *
     * @param dateValue the new date value
     */
    public final void setDateValue(final DateValue dateValue) {
        this.dateValue = dateValue;
    }

	@Override
	public String toString() {
		return "Criteria [facilities=" + Arrays.toString(facilities) + ", format=" + format + ", fromFacilities="
				+ Arrays.toString(fromFacilities) + ", numResults=" + numResults + ", visnClaims=" + visnClaims
				+ ", project=" + project + ", reasons=" + Arrays.toString(reasons) + ", report=" + report
				+ ", reportName=" + reportName + ", reportTypes=" + Arrays.toString(reportTypes) + ", serviceCodes="
				+ Arrays.toString(serviceCodes) + ", sortBy=" + sortBy + ", toFacilities="
				+ Arrays.toString(toFacilities) + ", transCodes=" + Arrays.toString(transCodes) + ", dateValue="
				+ dateValue + "]";
	}

    
}
