package gov.va.med.fee.model.request;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import gov.va.med.domain.fee.AppUser;

/**
 * 
 * @author DNS   YIBRIK
 * yibrie.kedir@gmail.com
 *
 */
public class PrivacyRestrictionRequest {

	@NotNull
	private AppUser appuser;
	@NotNull
	private String ntName;
	@NotNull
    @Size(min=1, max=200, message="Reason  Max length is 200")
	private String reason;
	@NotNull
	private String ssn;
	@NotNull
	private String type;
	
	/**
	 * Constructor using all fields 
	 * @param appuser
	 * @param ntName
	 * @param reason
	 * @param ssn
	 * @param type
	 */
	public PrivacyRestrictionRequest(AppUser appuser, String ntName, String reason, String ssn, String type) {

		this.appuser = appuser;
		this.ntName = ntName;
		this.reason = reason;
		this.ssn = ssn;
		this.type = type;
	}
	 
	/**
	 * default constructor 
	 */
	public PrivacyRestrictionRequest(){}

	
	/**
	 * getter and setters for all fields -- auto generated 
	 */
	
	public AppUser getAppuser() {
		return appuser;
	}

	public void setAppuser(AppUser appuser) {
		this.appuser = appuser;
	}

	public String getNtName() {
		return ntName;
	}

	public void setNtName(String ntName) {
		this.ntName = ntName;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((appuser == null) ? 0 : appuser.hashCode());
		result = prime * result + ((ntName == null) ? 0 : ntName.hashCode());
		result = prime * result + ((reason == null) ? 0 : reason.hashCode());
		result = prime * result + ((ssn == null) ? 0 : ssn.hashCode());
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PrivacyRestrictionRequest other = (PrivacyRestrictionRequest) obj;
		if (appuser == null) {
			if (other.appuser != null)
				return false;
		} else if (!appuser.equals(other.appuser))
			return false;
		if (ntName == null) {
			if (other.ntName != null)
				return false;
		} else if (!ntName.equals(other.ntName))
			return false;
		if (reason == null) {
			if (other.reason != null)
				return false;
		} else if (!reason.equals(other.reason))
			return false;
		if (ssn == null) {
			if (other.ssn != null)
				return false;
		} else if (!ssn.equals(other.ssn))
			return false;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "PrivacyRestriction [appuser=" + appuser.getUserName() + ", ntName=" + ntName + ", reason=" + reason + ", ssn=" + ssn
				+ ", type=" + type + "]";
	}
	
	
	
}
