package gov.va.med.fee.model.request;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class ManualReconRequest {

	List<AdjustmentRequest> adjustments;

	/** The payment date. */
	/** TODAY OR ANY DAY BEFORE TODAY **/
	// @Past
	private Date paymentDate;

	/** The va amount. */
	// @Min(0)
	private BigDecimal vaAmount;

	/** The check no. */
	private String checkNo;

	/** The payment type. */
	// @NotNull
	private String paymentType;

	/** The claim index. */
	private Long claimIndex;

	/** The claim proc id. */
	private Long claimProcId;

	private String userName;

	public List<AdjustmentRequest> getAdjustments() {
		return adjustments;
	}

	public void setAdjustments(List<AdjustmentRequest> adjustments) {
		this.adjustments = adjustments;
	}

	public Date getPaymentDate() {
		return paymentDate;
	}

	public void setPaymentDate(Date paymentDate) {
		this.paymentDate = paymentDate;
	}

	public BigDecimal getVaAmount() {
		return vaAmount;
	}

	public void setVaAmount(BigDecimal vaAmount) {
		this.vaAmount = vaAmount;
	}

	public String getCheckNo() {
		return checkNo;
	}

	public void setCheckNo(String checkNo) {
		this.checkNo = checkNo;
	}

	public String getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

	public Long getClaimIndex() {
		return claimIndex;
	}

	public void setClaimIndex(Long claimIndex) {
		this.claimIndex = claimIndex;
	}

	public Long getClaimProcId() {
		return claimProcId;
	}

	public void setClaimProcId(Long claimProcId) {
		this.claimProcId = claimProcId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ManualReconRequest [adjustments=");
		builder.append(adjustments);
		builder.append(", paymentDate=");
		builder.append(paymentDate);
		builder.append(", vaAmount=");
		builder.append(vaAmount);
		builder.append(", checkNo=");
		builder.append(checkNo);
		builder.append(", paymentType=");
		builder.append(paymentType);
		builder.append(", claimIndex=");
		builder.append(claimIndex);
		builder.append(", claimProcId=");
		builder.append(claimProcId);
		builder.append(", userName=");
		builder.append(userName);
		builder.append("]");
		return builder.toString();
	}

	/**
	 * Gets the total amount.
	 *
	 * @return the total amount
	 */
	public BigDecimal getTotalAmount() {

		BigDecimal total = BigDecimal.ZERO;

		total = total.setScale(2);

		if (vaAmount != null) {
			vaAmount = vaAmount.setScale(2);
			total = total.add(vaAmount);
		}

		// add all adjustment amounts
		for (AdjustmentRequest adjustmentRequest : adjustments) {
			BigDecimal amount = adjustmentRequest.getAmount();
			total = total.add(amount.setScale(2));
		}

		return total;
	}

}
