/**
 * 
 */
package gov.va.med.fee.model.request;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public class ContactInfoRequest {

	@NotNull
	private String appUserName;
	private Long contactInfoId;
	@NotNull
	@Size(min=1, max=12)
    private String vaFacilityCd;
	@NotNull
	private String contactType;
	private String contactName;
	@Size(min=0, max=50, message="Address 1 max length is 50")
	private String address1;
	@Size(min=0, max=50, message="Address 2 max length is 50")
	private String address2;
	@Size(min=0, max=50)
	private String city;
	@Size(min=0, max=5, message="Zip code max length is 5")
	private String zip;
	@Size(min=0, max=12, message="Phone max length is 12")
	private String phone;
	@Size(min=0, max=50 , message="Email max length is 12")
	private String email;
	@Size(min=0, max=12, message="Fax max length is 12")
	private String fax;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String createdBy;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String dateCreated;

	public ContactInfoRequest() {
		super();
	}

	public ContactInfoRequest(Long contactInfoId, String vaFacility, String contactType, String contactName,
			String address1, String address2, String city, String zip, String phone, String email, String fax,
			String appUserName, String dateCreated) {
		super();
		this.contactInfoId = contactInfoId;
		this.vaFacilityCd = vaFacility;
		this.contactType = contactType;
		this.contactName = contactName;
		this.address1 = address1;
		this.address2 = address2;
		this.city = city;
		this.zip = zip;
		this.phone = phone;
		this.email = email;
		this.fax = fax;
		this.appUserName = appUserName;
		this.dateCreated = dateCreated;
	}

	public Long getContactInfoId() {
		return contactInfoId;
	}

	public void setContactInfoId(Long contactInfoId) {
		this.contactInfoId = contactInfoId;
	}

	public String getVaFacilityCd() {
		return vaFacilityCd;
	}

	public void setVaFacilityCd(String vaFacility) {
		this.vaFacilityCd = vaFacility;
	}

	public String getContactType() {
		return contactType;
	}

	public void setContactType(String contactType) {
		this.contactType = contactType;
	}

	public String getContactName() {
		return contactName;
	}

	public void setContactName(String contactName) {
		this.contactName = contactName;
	}

	public String getAddress1() {
		return address1;
	}

	public void setAddress1(String address1) {
		this.address1 = address1;
	}

	public String getAddress2() {
		return address2;
	}

	public void setAddress2(String address2) {
		this.address2 = address2;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	public String getAppUserName() {
		return appUserName;
	}

	public void setAppUserName(String appUserName) {
		this.appUserName = appUserName;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(String dateCreated) {
		this.dateCreated = dateCreated;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ContactInfoRequest [contactInfoId=");
		builder.append(contactInfoId);
		builder.append(", vaFacility=");
		builder.append(vaFacilityCd);
		builder.append(", contactType=");
		builder.append(contactType);
		builder.append(", contactName=");
		builder.append(contactName);
		builder.append(", address1=");
		builder.append(address1);
		builder.append(", address2=");
		builder.append(address2);
		builder.append(", city=");
		builder.append(city);
		builder.append(", zip=");
		builder.append(zip);
		builder.append(", phone=");
		builder.append(phone);
		builder.append(", email=");
		builder.append(email);
		builder.append(", fax=");
		builder.append(fax);
		builder.append(", createdBy=");
		builder.append(createdBy);
		builder.append(", dateCreated=");
		builder.append(dateCreated);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((address1 == null) ? 0 : address1.hashCode());
		result = prime * result + ((address2 == null) ? 0 : address2.hashCode());
		result = prime * result + ((appUserName == null) ? 0 : appUserName.hashCode());
		result = prime * result + ((city == null) ? 0 : city.hashCode());
		result = prime * result + ((contactInfoId == null) ? 0 : contactInfoId.hashCode());
		result = prime * result + ((contactName == null) ? 0 : contactName.hashCode());
		result = prime * result + ((contactType == null) ? 0 : contactType.hashCode());
		result = prime * result + ((createdBy == null) ? 0 : createdBy.hashCode());
		result = prime * result + ((dateCreated == null) ? 0 : dateCreated.hashCode());
		result = prime * result + ((email == null) ? 0 : email.hashCode());
		result = prime * result + ((fax == null) ? 0 : fax.hashCode());
		result = prime * result + ((phone == null) ? 0 : phone.hashCode());
		result = prime * result + ((vaFacilityCd == null) ? 0 : vaFacilityCd.hashCode());
		result = prime * result + ((zip == null) ? 0 : zip.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ContactInfoRequest other = (ContactInfoRequest) obj;
		if (address1 == null) {
			if (other.address1 != null)
				return false;
		} else if (!address1.equals(other.address1))
			return false;
		if (address2 == null) {
			if (other.address2 != null)
				return false;
		} else if (!address2.equals(other.address2))
			return false;
		if (appUserName == null) {
			if (other.appUserName != null)
				return false;
		} else if (!appUserName.equals(other.appUserName))
			return false;
		if (city == null) {
			if (other.city != null)
				return false;
		} else if (!city.equals(other.city))
			return false;
		if (contactInfoId == null) {
			if (other.contactInfoId != null)
				return false;
		} else if (!contactInfoId.equals(other.contactInfoId))
			return false;
		if (contactName == null) {
			if (other.contactName != null)
				return false;
		} else if (!contactName.equals(other.contactName))
			return false;
		if (contactType == null) {
			if (other.contactType != null)
				return false;
		} else if (!contactType.equals(other.contactType))
			return false;
		if (createdBy == null) {
			if (other.createdBy != null)
				return false;
		} else if (!createdBy.equals(other.createdBy))
			return false;
		if (dateCreated == null) {
			if (other.dateCreated != null)
				return false;
		} else if (!dateCreated.equals(other.dateCreated))
			return false;
		if (email == null) {
			if (other.email != null)
				return false;
		} else if (!email.equals(other.email))
			return false;
		if (fax == null) {
			if (other.fax != null)
				return false;
		} else if (!fax.equals(other.fax))
			return false;
		if (phone == null) {
			if (other.phone != null)
				return false;
		} else if (!phone.equals(other.phone))
			return false;
		if (vaFacilityCd == null) {
			if (other.vaFacilityCd != null)
				return false;
		} else if (!vaFacilityCd.equals(other.vaFacilityCd))
			return false;
		if (zip == null) {
			if (other.zip != null)
				return false;
		} else if (!zip.equals(other.zip))
			return false;
		return true;
	}	
}
