/**
 * 
 */
package gov.va.med.fee.model.request;

import java.math.BigDecimal;

import org.springframework.stereotype.Component;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Component
public class CarcInfoRequest {
	
	BigDecimal dprocSeq;
	String prevAdjReasonCode;
	BigDecimal bdAdjAmt1;
	BigDecimal bdPaidAmt;
	/**
	 * 
	 */
	public CarcInfoRequest() {
	}
	
	/**
	 * @param dprocSeq
	 * @param prevAdjReasonCode
	 * @param bdAdjAmt1
	 * @param bdPaidAmt
	 */
	public CarcInfoRequest(BigDecimal dprocSeq, String prevAdjReasonCode, BigDecimal bdAdjAmt1,
			BigDecimal bdPaidAmt) {
		super();
		this.dprocSeq = dprocSeq;
		this.prevAdjReasonCode = prevAdjReasonCode;
		this.bdAdjAmt1 = bdAdjAmt1;
		this.bdPaidAmt = bdPaidAmt;
	}

	/**
	 * @return the dprocSeq
	 */
	public BigDecimal getDprocSeq() {
		return dprocSeq;
	}

	/**
	 * @param dprocSeq the dprocSeq to set
	 */
	public void setDprocSeq(BigDecimal dprocSeq) {
		this.dprocSeq = dprocSeq;
	}

	/**
	 * @return the prevAdjReasonCode
	 */
	public String getPrevAdjReasonCode() {
		return prevAdjReasonCode;
	}

	/**
	 * @param prevAdjReasonCode the prevAdjReasonCode to set
	 */
	public void setPrevAdjReasonCode(String prevAdjReasonCode) {
		this.prevAdjReasonCode = prevAdjReasonCode;
	}

	/**
	 * @return the bdAdjAmt1
	 */
	public BigDecimal getBdAdjAmt1() {
		return bdAdjAmt1;
	}

	/**
	 * @param bdAdjAmt1 the bdAdjAmt1 to set
	 */
	public void setBdAdjAmt1(BigDecimal bdAdjAmt1) {
		this.bdAdjAmt1 = bdAdjAmt1;
	}

	/**
	 * @return the bdPaidAmt
	 */
	public BigDecimal getBdPaidAmt() {
		return bdPaidAmt;
	}

	/**
	 * @param bdPaidAmt the bdPaidAmt to set
	 */
	public void setBdPaidAmt(BigDecimal bdPaidAmt) {
		this.bdPaidAmt = bdPaidAmt;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((bdAdjAmt1 == null) ? 0 : bdAdjAmt1.hashCode());
		result = prime * result + ((bdPaidAmt == null) ? 0 : bdPaidAmt.hashCode());
		result = prime * result + ((dprocSeq == null) ? 0 : dprocSeq.hashCode());
		result = prime * result + ((prevAdjReasonCode == null) ? 0 : prevAdjReasonCode.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CarcInfoRequest other = (CarcInfoRequest) obj;
		if (bdAdjAmt1 == null) {
			if (other.bdAdjAmt1 != null)
				return false;
		} else if (!bdAdjAmt1.equals(other.bdAdjAmt1))
			return false;
		if (bdPaidAmt == null) {
			if (other.bdPaidAmt != null)
				return false;
		} else if (!bdPaidAmt.equals(other.bdPaidAmt))
			return false;
		if (dprocSeq == null) {
			if (other.dprocSeq != null)
				return false;
		} else if (!dprocSeq.equals(other.dprocSeq))
			return false;
		if (prevAdjReasonCode == null) {
			if (other.prevAdjReasonCode != null)
				return false;
		} else if (!prevAdjReasonCode.equals(other.prevAdjReasonCode))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CarcInfoRequest [dprocSeq=");
		builder.append(dprocSeq);
		builder.append(", prevAdjReasonCode=");
		builder.append(prevAdjReasonCode);
		builder.append(", bdAdjAmt1=");
		builder.append(bdAdjAmt1);
		builder.append(", bdPaidAmt=");
		builder.append(bdPaidAmt);
		builder.append("]");
		return builder.toString();
	}
	
	

}
