/*package gov.va.med.fee.logging;

import java.util.Arrays;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;


@Aspect
@Component
public class LoggingHandler {

	private static final Logger logger = LogManager.getLogger(LoggingHandler.class);
	
	
	//Around -> Any method within resource annotated with @RestController annotation 
	@Around("execution(* gov.va.med.fee.rs..*(..))")
	public void logAround(ProceedingJoinPoint joinPoint) throws Throwable {
		logger.info("RestControllerAspect");
		
		logger.info("hijacked method : " + joinPoint.getSignature().getName());
		logger.info("hijacked arguments : " + Arrays.toString(joinPoint.getArgs()));
		joinPoint.proceed(); // continue on the intercepted method
		
		logger.info("******");
	}
}


*/