/**
 *  @author Eyuel Taddese
 *
 */
package gov.va.med.fee.filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

public class CORSFilter extends OncePerRequestFilter {

/* (non-Javadoc)
 * @see org.springframework.web.filter.OncePerRequestFilter#doFilterInternal(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.FilterChain)
 */
protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
	res.setHeader("Access-Control-Allow-Origin", "*");
	res.setHeader("Access-Control-Allow-Methods", "GET,POST");
	res.setHeader("Access-Control-Max-Age", "3600");
	res.setHeader("Access-Control-Allow-Headers", "X-PINGOTHER, Content-Type, X-Requested-With, accept, Origin,"
			+"Access-Control-Request-Method, Access-Control-Request-Headers,Authorization");
	res.addHeader("Access-Control-Expose-Headers","xsrf-token");
	
	if ( "OPTIONS".equals(req.getMethod())) {
		res.setStatus(HttpServletResponse.SC_OK);
	} else {
		chain.doFilter(req,res);
	}
}
}
