package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.UserRoleUsages;
import gov.va.med.fee.dao.IUserRolesUsageRepository;
import gov.va.med.fee.dao.IVaFacilityRepositoryTemplate;
import gov.va.med.fee.model.request.VaFacilityRequest;
import gov.va.med.fee.model.request.VaFacilitySearchRequest;
import gov.va.med.fee.model.response.VaFacilityResponse;
import gov.va.med.fee.model.response.VaFacilityTypeResponse;
import gov.va.med.fee.model.response.VaFacilityVisnResponse;
import gov.va.med.fee.util.ReplaceWildCardEntries;

@Repository
public class VaFacilityRepositoryTempateImpl implements IVaFacilityRepositoryTemplate {

	private static final Logger logger = LogManager.getLogger(VaFacilityRepositoryTempateImpl.class);

	private JdbcTemplate jdbcTemplate;

	private static final Pattern WHERE_PATTERN = Pattern.compile("\\s(where)\\s", Pattern.CASE_INSENSITIVE);

	SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");

	@Autowired
	IUserRolesUsageRepository iUserRolesUsageRepository;

	ReplaceWildCardEntries replaceWildCardEntries = null;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<VaFacilityVisnResponse> getAllVisnsForFormLoad() {
		String sql = "select * from visn v order by v.visn_id_cd";
		List<VaFacilityVisnResponse> visns = jdbcTemplate.query(sql, new RowMapper<VaFacilityVisnResponse>() {
			public VaFacilityVisnResponse mapRow(ResultSet rs, int rowNum) throws SQLException {
				VaFacilityVisnResponse visn = new VaFacilityVisnResponse();
				visn.setVisnIdCd(rs.getLong("VISN_ID_CD"));
				visn.setDescription(rs.getString("DESCRIPTION"));
				return visn;
			}
		});
		return visns;
	}

	@Override
	public List<VaFacilityTypeResponse> getAllVaFacilityTypeForFormLoad() {
		String sql = "select rownum, v.va_type_cd, v.description from va_facility_type v order by rownum ";
		List<VaFacilityTypeResponse> va_facility_types = jdbcTemplate.query(sql,
				new RowMapper<VaFacilityTypeResponse>() {
					public VaFacilityTypeResponse mapRow(ResultSet rs, int rowNum) throws SQLException {
						VaFacilityTypeResponse vaFacType = new VaFacilityTypeResponse();
						vaFacType.setVaTypeCd(rs.getString("VA_TYPE_CD"));
						vaFacType.setDescription(rs.getString("DESCRIPTION"));
						return vaFacType;
					}
				});
		return va_facility_types;
	}

	@Override
	public int insertNewVaFacility(VaFacilityRequest addFacilityRequest) {

		int rowNum;
		int numberOfStations = checkVaFacility(addFacilityRequest.getVaFacilityCd());
		if (numberOfStations == 0) {

			String sql = new String(
					"INSERT INTO fpps_owner.va_facility (" + "va_facility_cd, visn_id_cd, va_type_cd, short_name, "
							+ "va_facility_name, aged_definition, parent_va_facility_cd, "
							+ "rerouting_allowed, created_by, date_created)" + " VALUES(?,?,?,?,?,?,?,?,?,sysdate)");

			rowNum = jdbcTemplate.update(sql, addFacilityRequest.getVaFacilityCd(), addFacilityRequest.getVisnIdCd(),
					addFacilityRequest.getVaTypeCd(), addFacilityRequest.getShortName(),
					addFacilityRequest.getVaFacilityName(), addFacilityRequest.getAgedDefinition(),
					addFacilityRequest.getParentVaFacilityCd(), addFacilityRequest.isReroutingAllowed() ? 1 : 0,
					addFacilityRequest.getAppUserName().trim());
			logger.debug("Inserted new VA Facility {} with VISN {} into the VA Facility table",
					addFacilityRequest.getVaFacilityCd(), addFacilityRequest.getVisnIdCd());
		} else {
			rowNum = 0;
		}

		return rowNum;
	}

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 */
	@Override
	public int modifyVaFacility(VaFacilityRequest modifyFacilityRequest) {
		boolean visnResponse = false;
		boolean faciltyResponse = false;
		int rowNum;
		int numberOfStations = checkVaFacility(modifyFacilityRequest.getVaFacilityCd());
		List<VaFacilityVisnResponse> visnInfo = getAllVisnsForFormLoad();

		List<VaFacilityTypeResponse> facilityType = getAllVaFacilityTypeForFormLoad();

		/*
		 * if (numberOfStations > 0 && visnResponse && faciltyResponse) { String
		 * sql = new String(
		 * "UPDATE fpps_owner.va_facility SET VISN_ID_CD = ?, VA_TYPE_CD = ?, SHORT_NAME = ?, VA_FACILITY_NAME = ?, AGED_DEFINITION = ?, PARENT_VA_FACILITY_CD = ?, REROUTING_ALLOWED = ?, MODIFIED_BY = ?, DATE_MODIFIED = sysdate where VA_FACILITY_CD = ?"
		 * );
		 * 
		 * rowNum = jdbcTemplate.update(sql,
		 * modifyFacilityRequest.getVisnIdCd(),
		 * modifyFacilityRequest.getVaTypeCd().toUpperCase(),
		 * modifyFacilityRequest.getShortName().toUpperCase(),
		 * modifyFacilityRequest.getVaFacilityName().toUpperCase(),
		 * modifyFacilityRequest.getAgedDefinition(),
		 * modifyFacilityRequest.getParentVaFacilityCd().toUpperCase(),
		 * modifyFacilityRequest.isReroutingAllowed() ? 1 : 0,
		 * modifyFacilityRequest.getAppUserName().trim().toUpperCase(),
		 * modifyFacilityRequest.getVaFacilityCd().toUpperCase()); logger.
		 * debug("modified new VA Facility {} with VISN {} into the VA Facility table"
		 * , modifyFacilityRequest.getVaFacilityCd(),
		 * modifyFacilityRequest.getVisnIdCd()); } else { rowNum = 0; }
		 */

		if (numberOfStations > 0) {
			for (VaFacilityVisnResponse str : visnInfo) {
				if (str.getVisnIdCd() == modifyFacilityRequest.getVisnIdCd()) {
					visnResponse = true;
					break;
				}
			}

			for (VaFacilityTypeResponse facility : facilityType) {
				if (facility.getVaTypeCd().equalsIgnoreCase(modifyFacilityRequest.getVaTypeCd())) {
					faciltyResponse = true;
					break;
				}
			}

			rowNum = 1;

		} else {
			rowNum = 0;
		}

		return rowNum;
	}

	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 */
	@Override
	public List<VaFacilityResponse> getSearchResults(VaFacilitySearchRequest searchRequest) {

		List<VaFacilityResponse> vaFacilityList = new LinkedList<VaFacilityResponse>();

		try {
			StringBuilder sqlQuery = generateSqlQuery(searchRequest);
			logger.debug("getCodes() : Query used to get the station results is : " + sqlQuery);
			vaFacilityList = jdbcTemplate.query(sqlQuery.toString(),
					new ResultSetExtractor<List<VaFacilityResponse>>() {

						@Override
						public List<VaFacilityResponse> extractData(ResultSet arg0)
								throws SQLException, DataAccessException {
							List<VaFacilityResponse> vaFacilityList = new ArrayList<VaFacilityResponse>();
							VaFacilityResponse vaFacility = null;

							while (arg0.next()) {
								vaFacility = new VaFacilityResponse();

								String dateCreated = sdf.format(arg0.getDate("DATE_CREATED"));
								vaFacility.setStation(arg0.getString("VA_FACILITY_CD"));
								vaFacility.setShortName(arg0.getString("SHORT_NAME"));
								vaFacility.setStationName(arg0.getString("VA_FACILITY_NAME"));
								vaFacility.setStationType(arg0.getString("VA_TYPE_CD"));
								vaFacility.setVisnNumber(arg0.getString("VISN_ID_CD"));
								vaFacility.setAllowReroute(arg0.getBoolean("REROUTING_ALLOWED"));
								vaFacility.setAgedDef(arg0.getBigDecimal("AGED_DEFINITION"));
								vaFacility.setParentStation(arg0.getString("PARENT_VA_FACILITY_CD"));
								vaFacility.setCreatedBy(arg0.getString("CREATED_BY"));
								vaFacility.setDateCreated(dateCreated);

								vaFacilityList.add(vaFacility);
							}
							return vaFacilityList;
						}
					});
		} catch (Exception e) {
			logger.debug("getCodes() : Exception occured :" + e);
			e.printStackTrace();
			throw e;
		}

		logger.debug("getCodes() : station results List is " + vaFacilityList);

		return vaFacilityList;
	}

	private StringBuilder generateSqlQuery(VaFacilitySearchRequest searchRequest) {
		StringBuilder sqlQuery = new StringBuilder();
		StringBuilder sql = new StringBuilder();
		StringBuilder sortByCriteria = new StringBuilder();
		replaceWildCardEntries = new ReplaceWildCardEntries();

		String column = getVaFacilityCodeTableColumnName(searchRequest.getSortColumn());
		if (column == "VA_FACILITY_CD") {
			searchRequest.setSortColumn("station");
		}
		sortByCriteria.append(" order by " + column);

		if (searchRequest.getDescending() == null || searchRequest.getDescending() == false) {
			sortByCriteria.append(" ASC ");
		} else {
			sortByCriteria.append(" DESC");
		}

		if (searchRequest.getUserRole().equalsIgnoreCase("ADMIN")
				|| searchRequest.getUserRole().equalsIgnoreCase("FEE_VISN_PGM_MANAGER")
				|| searchRequest.getUserRole().equalsIgnoreCase("FEE_SUPERVISOR")) {

			sqlQuery.append(
					"select vaFacility.*, ROW_NUMBER() OVER (" + sortByCriteria + ") r from VA_FACILITY vaFacility");

			if (searchRequest.getStation() != null && searchRequest.getStation() != ""
					&& !searchRequest.getStation().equals("%") && !searchRequest.getStation().equals("_")) {

				sqlQuery.append(" WHERE VA_FACILITY_CD like " + "'" + searchRequest.getStation() + '%' + "'");
			}

			if (searchRequest.getShortName() != null && searchRequest.getShortName() != ""
					&& !searchRequest.getShortName().equals("%") && !searchRequest.getShortName().equals("_")) {
				if (searchRequest.getStation() != null && searchRequest.getStation() != ""
						&& !searchRequest.getStation().equals("%") && !searchRequest.getStation().equals("_")) {
					sqlQuery.append(" AND regexp_like(SHORT_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getShortName()) + "', 'i')");
				} else {
					sqlQuery.append(" WHERE regexp_like(SHORT_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getShortName()) + "', 'i')");
				}
			}

			if (searchRequest.getStationName() != null && searchRequest.getStationName() != ""
					&& !searchRequest.getStationName().equals("%") && !searchRequest.getStationName().equals("_")) {
				if ((searchRequest.getStation() != null && searchRequest.getStation() != ""
						&& !searchRequest.getStation().equals("%") && !searchRequest.getStation().equals("_"))
						|| (searchRequest.getShortName() != null && searchRequest.getShortName() != ""
								&& !searchRequest.getShortName().equals("%")
								&& !searchRequest.getShortName().equals("_"))) {
					sqlQuery.append(" AND regexp_like(VA_FACILITY_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getStationName()) + "', 'i')");
				} else {
					sqlQuery.append(" WHERE regexp_like(VA_FACILITY_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getStationName()) + "', 'i')");
				}
			}

			if (searchRequest.getUserRole().equalsIgnoreCase("FEE_VISN_PGM_MANAGER")) {
				sqlQuery = generateSqlQueryForPgmManager(sqlQuery, searchRequest);
			}

			if (searchRequest.getUserRole().equalsIgnoreCase("FEE_SUPERVISOR")) {
				sqlQuery = generateSqlQueryForSupervisor(sqlQuery, searchRequest);
			}

		}

		if ((searchRequest.getPageSize() != null) && (searchRequest.getPageNumber() != null)
				&& searchRequest.getPageNumber() >= 1) {

			int currentUpperLimit = searchRequest.getPageSize() * searchRequest.getPageNumber();
			int currentLowerLimit = currentUpperLimit - searchRequest.getPageSize();
			sql.append(
					"select * from (" + sqlQuery + ") where r >" + currentLowerLimit + " AND r<=" + currentUpperLimit);

		}

		return sql;

	}

	private String getVaFacilityCodeTableColumnName(String param) {
		if (param != null) {
			switch (param) {
			case "station":
				return "lpad(VA_FACILITY_CD, 200)";
			case "shortName":
				return "SHORT_NAME";
			case "stationName":
				return "VA_FACILITY_NAME";
			case "stationType":
				return "VA_TYPE_CD";
			case "visnNumber":
				return "VISN_ID_CD";
			case "allowReroute":
				return "REROUTING_ALLOWED";
			case "agedDef":
				return "AGED_DEFINITION";
			case "parentStation":
				return "PARENT_VA_FACILITY_CD";
			case "createdBy":
				return "CREATED_BY";
			default:
				return "lpad(VA_FACILITY_CD, 200)";
			}
		} else {
			return "lpad(VA_FACILITY_CD, 200)";
		}
	}

	private StringBuilder generateSqlQueryForSupervisor(StringBuilder sqlQuery, VaFacilitySearchRequest searchRequest) {

		StringBuilder builder = new StringBuilder().append(sqlQuery);
		List<UserRoleUsages> userRoleUsages = iUserRolesUsageRepository.findByUserRoleName(searchRequest.getUserRole());
		if (searchRequest.getStation() != null && searchRequest.getStation() != "" && userRoleUsages.size() > 0) {
			if (WHERE_PATTERN.matcher(builder).find()) {
				builder.append(" and ");
			} else {
				builder.append(" where ");
			}
			// supervisors are limited to stations
			builder.append("vaFacility.VA_FACILITY_CD in ").append(getFacilities(searchRequest));
		}
		return builder;
	}

	private StringBuilder generateSqlQueryForPgmManager(StringBuilder sqlQuery, VaFacilitySearchRequest searchRequest) {
		StringBuilder sqlQueryForManager = new StringBuilder().append(sqlQuery);
		if (WHERE_PATTERN.matcher(sqlQueryForManager).find()) {
			sqlQueryForManager.append(" and ");
		} else {
			sqlQueryForManager.append(" where ");
		}
		String q = "select distinct (v.visn_id_cd) from Va_Facility v where v.va_facility_cd in "
				+ getFacilities(searchRequest);

		List<VaFacilityVisnResponse> vaFacility = getResultfromQuery(q);

		List<Object> vaFacilityList = new ArrayList<>();
		for (VaFacilityVisnResponse row : vaFacility) {
			vaFacilityList.add(row.getVisnIdCd());
		}
		String visnList = vaFacilityList.toString();
		visnList = visnList.replace('[', '(');
		visnList = visnList.replace(']', ')');

		sqlQueryForManager.append("vaFacility.VISN_ID_CD in ").append(visnList);
		return sqlQueryForManager;

	}

	private List<VaFacilityVisnResponse> getResultfromQuery(String q) {

		List<VaFacilityVisnResponse> vaFacilityList = new ArrayList<VaFacilityVisnResponse>();
		try {
			vaFacilityList = jdbcTemplate.query(q, new ResultSetExtractor<List<VaFacilityVisnResponse>>() {
				@Override
				public List<VaFacilityVisnResponse> extractData(ResultSet rs) throws SQLException, DataAccessException {
					List<VaFacilityVisnResponse> vaFacilityList = new ArrayList<VaFacilityVisnResponse>();
					VaFacilityVisnResponse vaFacility = null;
					while (rs.next()) {
						vaFacility = new VaFacilityVisnResponse();
						vaFacility.setVisnIdCd(rs.getLong("VISN_ID_CD"));
						vaFacilityList.add(vaFacility);
					}
					return vaFacilityList;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vaFacilityList;
	}

	private String getFacilities(VaFacilitySearchRequest searchRequest) {
		StringBuilder facs = new StringBuilder("(");
		List<UserRoleUsages> userRoleUsages = iUserRolesUsageRepository.findByUserRoleName(searchRequest.getUserRole());
		if (userRoleUsages.size() > 0) {
			boolean first = true;
			for (UserRoleUsages urs : userRoleUsages) {
				if (!first) {
					facs.append(",");
				}
				facs.append("'").append(urs.getVaFacility().getVaFacilityCd()).append("'");
				first = false;
			}
			facs.append(")");
		}
		return facs.toString();
	}

	@Override
	public Long getSearchResultsCount(VaFacilitySearchRequest searchRequest) {
		StringBuilder sqlQuery = new StringBuilder();

		replaceWildCardEntries = new ReplaceWildCardEntries();

		if (searchRequest.getUserRole().equalsIgnoreCase("ADMIN")
				|| searchRequest.getUserRole().equalsIgnoreCase("FEE_VISN_PGM_MANAGER")
				|| searchRequest.getUserRole().equalsIgnoreCase("FEE_SUPERVISOR")) {

			sqlQuery.append("select COUNT(*) from VA_FACILITY vaFacility");

			if (searchRequest.getStation() != null && searchRequest.getStation() != ""
					&& !searchRequest.getStation().equals("%") && !searchRequest.getStation().equals("_")) {
				sqlQuery.append(" WHERE VA_FACILITY_CD like " + "'" + searchRequest.getStation() + '%' + "'");
			}

			if (searchRequest.getShortName() != null && searchRequest.getShortName() != ""
					&& !searchRequest.getShortName().equals("%") && !searchRequest.getShortName().equals("_")) {
				if (searchRequest.getStation() != null && searchRequest.getStation() != ""
						&& !searchRequest.getStation().equals("%") && !searchRequest.getStation().equals("_")) {
					sqlQuery.append(" AND regexp_like(SHORT_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getShortName()) + "', 'i')");
				} else {
					sqlQuery.append(" WHERE regexp_like(SHORT_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getShortName()) + "', 'i')");
				}
			}

			if (searchRequest.getStationName() != null && searchRequest.getStationName() != ""
					&& !searchRequest.getStationName().equals("%") && !searchRequest.getStationName().equals("_")) {
				if ((searchRequest.getStation() != null && searchRequest.getStation() != ""
						&& !searchRequest.getStation().equals("%") && !searchRequest.getStation().equals("_"))
						|| (searchRequest.getShortName() != null && searchRequest.getShortName() != ""
								&& !searchRequest.getShortName().equals("%")
								&& !searchRequest.getShortName().equals("_"))) {
					sqlQuery.append(" AND regexp_like(VA_FACILITY_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getStationName()) + "', 'i')");
				} else {
					sqlQuery.append(" WHERE regexp_like(VA_FACILITY_NAME, " + "'"
							+ replaceWildCardEntries.getReplacedCharacters(searchRequest.getStationName()) + "', 'i')");
				}
			}

			if (searchRequest.getUserRole().equalsIgnoreCase("FEE_VISN_PGM_MANAGER")) {
				sqlQuery = generateSqlQueryForPgmManager(sqlQuery, searchRequest);
			}

			if (searchRequest.getUserRole().equalsIgnoreCase("FEE_SUPERVISOR")) {
				sqlQuery = generateSqlQueryForSupervisor(sqlQuery, searchRequest);
			}

		}

		Long count = jdbcTemplate.queryForObject(sqlQuery.toString(), Long.class);
		return count;
	}

	@Override
	public int checkVaFacility(String stationName) {
		String sql = "select count(*) from VA_FACILITY vaFacility where vaFacility.VA_FACILITY_CD = :stationName";
		int count = jdbcTemplate.queryForObject(sql.toString(), new Object[] { stationName }, Integer.class);
		return count;
	}

}
