package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IUserSearchRepository;
import gov.va.med.fee.model.request.UserSearchRequest;
import gov.va.med.fee.model.response.UserSearchResponse;

@Repository
public class UserSearchRepositoryImpl implements IUserSearchRepository {
	private static final Logger logger = LogManager.getLogger(UserSearchRepositoryImpl.class);
	
	private int classCounter = 0;
	private HashMap<String, String> searchParametersToSet = new HashMap<String, String>();
	
	private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
	}
	
	@Override
	public List<UserSearchResponse> searchUsers(UserSearchRequest userSearchRequest) {
		String sql = sqlString(userSearchRequest);
		List<UserSearchResponse> userSearchResponse = new ArrayList<UserSearchResponse>();
		
		userSearchResponse = namedParameterJdbcTemplate.query(sql, searchParametersToSet,
				new ResultSetExtractor<List<UserSearchResponse>>() {
					@Override
					public List<UserSearchResponse> extractData(ResultSet rs) throws SQLException, DataAccessException {
						List<UserSearchResponse> userSearchResponseList = new ArrayList<UserSearchResponse>();
						UserSearchResponse userSearchResponse = null;					
						while (rs.next()) {	
							userSearchResponse = new UserSearchResponse();
							userSearchResponse.setUserName(rs.getString(2));
							userSearchResponse.setLastName(rs.getString(3));
							userSearchResponse.setFirstName(rs.getString(4));												
							userSearchResponse.setActive(rs.getString(5));
							if(rs.getDate(6) != null) {
								userSearchResponse.setLastLogin(formatDate(rs.getDate(6)));
							}
							userSearchResponse.setPhone(rs.getString(7));
							userSearchResponse.setEmail(rs.getString(8));
							userSearchResponseList.add(userSearchResponse);
						}
						return userSearchResponseList;
					}
				});
		classCounter = 0;
		searchParametersToSet.clear();
		return userSearchResponse;
	}
	
	private String sqlString(UserSearchRequest userSearchRequest) {
		String sql = "";
		
		sql = " select a.app_user_id, " 
                + " UPPER(a.user_name), "
                + " UPPER(a.last_name), "
                + " UPPER(a.first_name), "
                + " UPPER(a.enabled), "
                + " a.last_login_date, "
                + " UPPER(a.phone_number), "
                + " UPPER(a.email_address) "
                + " from app_user a "
                + " WHERE a.app_user_id is not null ";
		
		if(!(userSearchRequest.getUserName() == null) && !(userSearchRequest.getUserName().isEmpty())) {
			sql += appendSqlStringParameters(userSearchRequest.getUserName().toUpperCase(), "AND UPPER(a.user_name)", "");
		}
		if(!(userSearchRequest.getLastName() == null) && !(userSearchRequest.getLastName().isEmpty())) {
			sql += appendSqlStringParameters(userSearchRequest.getLastName().toUpperCase(), "AND UPPER(a.last_name)", "");
		}
		if(!(userSearchRequest.getFirstName() == null) && !(userSearchRequest.getFirstName().isEmpty())) {
			sql += appendSqlStringParameters(userSearchRequest.getFirstName().toUpperCase(), "AND UPPER(a.first_name)", "");
		}
        
		if(!(userSearchRequest.getPhone() == null) && !(userSearchRequest.getPhone().isEmpty())) {
			sql += appendSqlStringParameters(userSearchRequest.getPhone(), "AND UPPER(a.phone_number)", "");
		}
		
		if(!(userSearchRequest.getEmail() == null) && !(userSearchRequest.getEmail().isEmpty())) {
			sql += appendSqlStringParameters(userSearchRequest.getEmail().toUpperCase(), "AND UPPER(a.email_address)", "");
		}
        
        if(!(userSearchRequest.getStationId() == null) && !(userSearchRequest.getStationId().isEmpty())) {
        	sql += appendSqlStringParameters(userSearchRequest.getStationId().toUpperCase(), "AND a.app_user_id IN (SELECT u.app_user_id "
        		+ "FROM user_role_usages u WHERE u.va_facility_cd", ")");
        }
        
		return sql;
	}

	private String appendSqlStringParameters(String searchParam, String prefix, String suffix) {
		String ret = "";
		String param = "p" + classCounter++;
		logger.debug("searchParam: " + searchParam);
		if (searchParam != null && !searchParam.trim().equals("") && !searchParam.trim().equals("%")
				&& !searchParam.trim().equals("_")) {
			if (searchParam.trim().indexOf("%") >= 0 || searchParam.trim().indexOf("_") >= 0) {
				ret += " " + prefix + " LIKE :" + param + " " + suffix;
				searchParametersToSet.put(param, searchParam.toUpperCase());
			} else {
				ret += " " + prefix + " = :" + param + " " + suffix;
				searchParametersToSet.put(param, searchParam.toUpperCase());
			}
		}
		logger.debug("ret: " + ret);
		return ret;
	}
	
	private String formatDate(Date date) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
		return dateFormat.format(date).toString();
	}
}
