package gov.va.med.fee.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IUserRolePermissionsRepository;
import gov.va.med.fee.model.response.UserRolePermissions;

@Repository
public class UserRolePermissionsRepositoryImpl implements IUserRolePermissionsRepository{


	public static final Logger logger = LogManager.getLogger(UserRolePermissionsRepositoryImpl.class);

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<UserRolePermissions> getUserRolePermissions(String roleIds) {

		List<UserRolePermissions> userRolePermissionsList = new ArrayList<UserRolePermissions>();
		logger.info("getUserRolePermissions() value is : "+roleIds);
		
		String getPermissionsQuery = "SELECT p.PAGE_NAME, p.PERMISSION_NAME, p.ENABLED, p.PERMISSION_ID FROM fpps_owner.USER_ROLE_PERMISSIONS p WHERE p.app_role_id in ("+roleIds+")";
			           
		List<Map<String, Object>> rows = jdbcTemplate.queryForList(getPermissionsQuery);
		logger.info("getPermissionsQuery is :"+getPermissionsQuery);
		logger.info("number of rows selected are : "+rows.size());
		
		for ( Map<String, Object> rs : rows) {
			UserRolePermissions userRolePermission = new UserRolePermissions();
			
			logger.info("rs is: "+rs.toString());
			
			userRolePermission.setPageName(((String)rs.get("PAGE_NAME")));
			userRolePermission.setPermissionName(((String)rs.get("PERMISSION_NAME")));
			String enabled = (String)rs.get("ENABLED");
			if( enabled != null && (enabled.equals("Y") || enabled == "Y"))
			userRolePermission.setEnabled(Boolean.TRUE);
			else
			userRolePermission.setEnabled(Boolean.FALSE);
			
			userRolePermissionsList.add(userRolePermission);
		}
		
		logger.debug("userRolePermissionsList is :"+userRolePermissionsList);
	    return userRolePermissionsList;
	}

}
