package gov.va.med.fee.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.domain.fee.AppUser;
import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.fee.dao.IUserRequestRepositoryTemplate;
import gov.va.med.fee.model.request.StationRequest;
import gov.va.med.fee.model.request.UserReqRequest;
import gov.va.med.fee.model.response.UserRoles;


@Repository
public class UserRequestRepositoryTemplate implements IUserRequestRepositoryTemplate {
	private static final Logger logger = LogManager.getLogger(UserRequestRepositoryTemplate.class);
	
	private JdbcTemplate jdbcTemplate;

		
	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public AppUserRequest findRequestByAppUserName(@Param("username") String userName) {
		String sql = "select * from app_user_request a where a.USER_NAME=  ? order by a.APP_USER_REQUEST_ID";
			
		List<AppUserRequest> appUserRequests = new ArrayList<>();
		try {
			appUserRequests = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setString(1, userName);
				}
			}, new RowMapper<AppUserRequest>() {
				public AppUserRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
					AppUserRequest request = new AppUserRequest();
					request.setAppUserRequestId(rs.getLong("APP_USER_REQUEST_ID"));
					request.setUserName(rs.getString("USER_NAME"));
					request.setLastName(rs.getString("LAST_NAME"));
					request.setFirstName(rs.getString("FIRST_NAME"));
					request.setMiddleName(rs.getString("MIDDLE_NAME"));
					request.setPhoneNumber(rs.getString("PHONE_NUMBER"));
					request.setEmailAddress(rs.getString("EMAIL_ADDRESS"));
					request.setRequestRoles(rs.getString("REQUEST_ROLES"));
					request.setRequestFacilities(rs.getString("REQUEST_FACILITIES"));
					request.setEnabled(rs.getString("ENABLED"));
								
					return request;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		AppUserRequest appUserRequest = null;
		if(appUserRequests != null && appUserRequests.size() > 0) {
			appUserRequest = appUserRequests.get(0);
		}
		return appUserRequest;
	}
				
	//(findUserToEditByUserId) - load App User info for Modify User Uequest
	@Override
	public AppUser findRequestByAppUserId(Long appUserId) {
		String sql = " SELECT * from app_user a WHERE a.app_user_id= ?";
		
		List<AppUser> users = new ArrayList<>();
		try {
			users = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, appUserId);					
				}
			}, new RowMapper<AppUser>() {
				public AppUser mapRow(ResultSet rs, int rowNum) throws SQLException {
					AppUser userToEdit = new AppUser();
					userToEdit.setAppUserId(rs.getLong("APP_USER_ID"));
					userToEdit.setUserName(rs.getString("USER_NAME"));
			        userToEdit.setLastName(rs.getString("LAST_NAME"));
			        userToEdit.setFirstName(rs.getString("FIRST_NAME"));
			        userToEdit.setMiddleName(rs.getString("MIDDLE_NAME"));
			        userToEdit.setEnabled(rs.getString("ENABLED"));             
			        //this.userToEditEnabled=userToEdit.getEnabled().equalsIgnoreCase("Y") ? true : false;
			        userToEdit.setLastLoginDate(rs.getDate("LAST_LOGIN_DATE"));
			        userToEdit.setPhoneNumber(rs.getString("PHONE_NUMBER"));
			        userToEdit.setEmailAddress(rs.getString("EMAIL_ADDRESS"));
			        userToEdit.setDeactivationComments(rs.getString("DEACTIVATION_COMMENTS"));			
					return userToEdit;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		AppUser appUser = null;
		if(users != null && users.size() > 0) {
			appUser = users.get(0);
		}
		return appUser;
	}
	
	//(findUserToEditByUserId) - Requested Roles for User Administration - Modify User Request page
	@Override
	public List<UserRoles> findUserRolesForModify(Long appUserId) {
		String sql = "SELECT DISTINCT(a.app_role_id), a.role_name, a.description "
				+ " FROM app_role a, user_role_usages uru " 
				+ " WHERE a.app_role_id = uru.app_role_id "
				+ " and uru.app_user_id= ? ORDER BY a.role_name ASC ";
		
		List<UserRoles> userRoles = new ArrayList<>();
		try {
			userRoles = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, appUserId);					
				}
			}, new RowMapper<UserRoles>() {
				public UserRoles mapRow(ResultSet rs, int rowNum) throws SQLException {
					UserRoles info = new UserRoles();
					//info.setRoleId(rs.getLong("APP_ROLE_ID"));
					info.setRoleName(rs.getString("ROLE_NAME"));
					info.setDescription(rs.getString("DESCRIPTION"));
					return info;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return userRoles;
	}
	
	//(findUserToEditByUserId) - Requested Facilities for User Administration - Modify User Request page
	@Override
	public List<StationRequest> findUserFacilities (Long appUserId) {
		String sql = "SELECT DISTINCT(f.va_facility_cd),  f.visn_id_cd, f.short_name"
	             + " FROM va_facility f, user_role_usages uru"
	             + " WHERE f.va_facility_cd = uru.va_facility_cd"
	             + " and uru.app_user_id= ? ORDER BY f.visn_id_cd, f.va_facility_cd, f.short_name ASC"; 
		
		List<StationRequest> userFacilities = new ArrayList<>();
		try {
			userFacilities = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, appUserId);					
				}
			}, new RowMapper<StationRequest>() {
				public StationRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
					StationRequest info = new StationRequest();
					info.setVaFacilityCd(rs.getString("VA_FACILITY_CD"));
					info.setVisnIdCd(rs.getLong("VISN_ID_CD"));
					info.setShortName(rs.getString("SHORT_NAME"));
					return info;
				}
			});	
		} catch (Exception e) {
			e.printStackTrace();
		}		
		
		return userFacilities;
	}
	
	
	/*Available App Roles except ADMIN for User Administration - Create User Request page*/
	@Override
	public List<UserRoles> getRolesForRequest() {
		String sql = "select a.role_name "
				+ "from app_role a "
				+ "where a.role_name <> 'ADMIN' "
				+ "order by a.role_name";
		       
		List<UserRoles> rolesToSelectForRequest = jdbcTemplate.query(sql, new RowMapper<UserRoles>() {

			public UserRoles mapRow(ResultSet rs, int rowNum) throws SQLException {
				UserRoles info = new UserRoles();
				info.setRoleName(rs.getString("ROLE_NAME"));
				logger.debug("getRolesForRequest() -" + info);
				
				return info;
			}
		});
		return rolesToSelectForRequest;
	}
	
	/*Available Facilities for User Administration - Create User Request page*/
	@Override
	public List<StationRequest> getFacilitiesForRequest() {
		String sql = "SELECT DISTINCT(f.va_facility_cd), " 
				+ " f.visn_id_cd, " 
				+ " f.short_name "
				+ " FROM va_facility f " 
				+ " WHERE f.va_type_cd = 'FAC' "
				+ " ORDER BY f.visn_id_cd, f.va_facility_cd, f.short_name ASC ";
				
		List<StationRequest> stationsToSelectForRequest = jdbcTemplate.query(sql, new RowMapper<StationRequest>() {

			public StationRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
				StationRequest info = new StationRequest();
				info.setVaFacilityCd(rs.getString("VA_FACILITY_CD"));
				info.setVisnIdCd(rs.getLong("VISN_ID_CD"));
				info.setShortName(rs.getString("SHORT_NAME"));

				logger.debug("getFacilitiesForRequest() -" + info.getDisplayFacility());
				return info;
			}

		});

		return stationsToSelectForRequest;
	}
	
	/* Create new user request page
	 * appUserName - created By as the current user name*/
	@Transactional
	public int requestCreateUserRequest(UserReqRequest userReq, String appUserName) {
		
		String enabled = userReq.getEnabled() ? "Y" : "N";
	    
		String sql = new String("INSERT INTO fpps_owner.app_user_request(app_user_request_id, user_name, enabled, last_name, first_name, middle_name, " 
	            + " phone_number, email_address, request_roles, request_facilities, request_type, request_status, deactivation_comments, created_by, date_created) "
	            + " VALUES(fpps_owner.mig.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,sysdate)");
		
		int rowNum = jdbcTemplate.update(sql, userReq.getWindow_nt_name(), enabled, userReq.getLast_name(), userReq.getFirst_name(), userReq.getMiddle_name(),
				userReq.getPhone(), userReq.getEmail(), userReq.getRequestedRoles(), userReq.getRequestedFacilities(), userReq.getRequest_type(), 0, 
				userReq.getDisable_comments(), appUserName.trim().toUpperCase());		
		                   
		logger.debug("requestCreateModifyUser(): number row inserted = " + rowNum);
		return rowNum;
	}
		
	/*(findUserToEditByUserId) - Available App Roles except ADMIN for User Administration - Modify User Request*/
	@Override
	public List<String> getRolesAvailableToUserForUserModifyRequest() {
		String sql = "SELECT DISTINCT(ar.app_role_id), ar.role_name, ar.description "
				+ "FROM app_role ar "
				+ "WHERE ar.role_name <> 'ADMIN' "
				+ "ORDER BY ar.role_name ASC";
				
		List<String> rolesToSelectForRequest = jdbcTemplate.query(sql, new RowMapper<String>() {

			public String mapRow(ResultSet rs, int rowNum) throws SQLException {
				String info = rs.getString("ROLE_NAME").replaceAll("_", " ");
				logger.debug("getRolesForRequest() -" + info);
				
				return info;
			}

		});

		return rolesToSelectForRequest;
	}
	
	/*(findUserToEditByUserId) - Available Facilities for 'User Administration - Modify User Request' & 'User Administration - Modify User'*/
	@Override
	public List<StationRequest> getFacilitiesAvailableToUser() {
		String sql = "SELECT DISTINCT(f.va_facility_cd), "
	            + " f.visn_id_cd, " 
	            + " f.short_name "
	            + " FROM va_facility f "     
	            + " ORDER BY f.visn_id_cd, f.va_facility_cd, f.short_name ASC ";
		       
		List<StationRequest> stationsToSelectForRequest = jdbcTemplate.query(sql, new RowMapper<StationRequest>() {

			public StationRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
				StationRequest info = new StationRequest();
				info.setVaFacilityCd(rs.getString("VA_FACILITY_CD"));
				info.setVisnIdCd(rs.getLong("VISN_ID_CD"));
				info.setShortName(rs.getString("SHORT_NAME"));

				logger.debug("getFacilitiesForRequest() -" + info.getDisplayFacility());
				return info;
			}
		});
		return stationsToSelectForRequest;
	}
	

	/* Modify user request page
	 * appUserName - created By as the current user name*/
	@Transactional
	public int requestModifyUserRequest(UserReqRequest userReq, String appUserName) throws DataAccessException{
		String enabled = userReq.getEnabled() ? "Y" : "N";
	    
		String sql = "UPDATE fpps_owner.app_user_request set"
				+ " enabled = ? , last_name = ? , first_name = ? , middle_name = ?, "
				+ " phone_number = ? , email_address = ? ,"
				+ " request_roles = ? , request_facilities = ? ,"
				+ " request_type = ? , request_status = 0 ,"
				+ " modified_by = ? , date_modified = sysdate "
				+ " where USER_NAME= ? ";
		
		int rowNum = jdbcTemplate.update(sql, enabled, userReq.getLast_name(), userReq.getFirst_name(), userReq.getMiddle_name(),
				userReq.getPhone(), userReq.getEmail(), userReq.getRequestedRoles(), userReq.getRequestedFacilities(), userReq.getRequest_type(),  
				appUserName.trim().toUpperCase(), userReq.getWindow_nt_name());
		
		logger.debug("requestModifyUser(): number row updated = " + rowNum);
		return rowNum;
	}		
	
	@Override
	public int deleteUserRequest(String appUserName) {
		String sql = "DELETE FROM APP_USER_REQUEST WHERE USER_NAME=?";
		int rowNum = jdbcTemplate.update(sql, appUserName);
		return rowNum;
	}
	
}
