package gov.va.med.fee.dao.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.UserRoleUsages;
import gov.va.med.fee.dao.IUserFacilityDataRepository;
import gov.va.med.fee.model.response.ClaimCountDetails;
import gov.va.med.fee.model.response.ClaimCounts;
import gov.va.med.fee.model.response.UserStationDetails;

@Repository
public class UserFacilityDataRepositoryImpl implements IUserFacilityDataRepository {


	public static final Logger logger = LogManager.getLogger(UserFacilityDataRepositoryImpl.class);

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}


	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.IUserFacilityDataRepository#getUserStationsDetails(java.lang.String, java.util.Set)
	 */
	@Override
	public UserStationDetails getUserStationsDetails(String userName, Set<UserRoleUsages> userRoleUsages) {
		logger.info(" getUserStationsDetails() :"+userRoleUsages);
		StringBuilder facilityList = new StringBuilder("");
		if (userRoleUsages.size() > 0) {
			for (UserRoleUsages u : userRoleUsages) {
				if( facilityList.toString().equals("") )
					facilityList = facilityList.append("'"+u.getVaFacility().getVaFacilityCd()+"'");
				else
					facilityList = facilityList.append(",'"+u.getVaFacility().getVaFacilityCd()+"'");
			}
		}
		logger.info(" facilityList is :"+facilityList);
		Set<Integer> visnCdSet = getVisnCds(facilityList, userName);
		Set<String> visnCdSetString = new HashSet<String>();
		if ( visnCdSet != null ) {
			visnCdSet.forEach(visn -> {
				if( visn != null ) {
					visnCdSetString.add(visn.toString());
				}
			});
		}
		logger.debug(" visnCdSetString is :"+visnCdSetString);
		String visnSetString = String.join(",", visnCdSetString);
		
		String visnOnlyQuery = " or (c.va_facility_cd is null and c.visn_id_cd in ("+visnSetString+")) ";
		logger.info("VISN only claim sub query is :"+visnOnlyQuery);
		String queryToGetCounts="select c.va_facility_cd, c.claim_status_cd, count(c.claim_index) as claim_count from ws_fac_status c where c.claim_status_cd != 'COMPLETE' and (c.va_facility_cd in ("+facilityList+") "+visnOnlyQuery+") group by c.va_facility_cd, c.claim_status_cd  order by c.va_facility_cd";
		List<Map<String, Object>> rows = jdbcTemplate.queryForList(queryToGetCounts);
		logger.info("queryToGetCounts is :"+queryToGetCounts);
		logger.info("number of rows selected are : "+rows.size());
		UserStationDetails userStationDetails = new UserStationDetails();
		List<ClaimCounts> claimCountsList = new ArrayList<ClaimCounts>();
		Set<String> facilitySet = new HashSet<String>();
		for (Map<String, Object> rs : rows) {
			logger.info("rs is: "+rs.toString());

			String vaFacilityCd = (String)rs.get("VA_FACILITY_CD");
			String claimStatusCd = (String)rs.get("CLAIM_STATUS_CD");
			int claimCount = ((java.math.BigDecimal)rs.get("CLAIM_COUNT")).intValue();

			// Adding all facilities to this set
			facilitySet.add(vaFacilityCd);

			ClaimCounts claimCounts = new ClaimCounts();
			claimCounts.setClaimCount(claimCount);
			claimCounts.setClaimStatusCd(claimStatusCd);
			claimCounts.setVaFacilityCd(vaFacilityCd);

			claimCountsList.add(claimCounts);

			logger.debug("vaFacilityCd : "+vaFacilityCd+" claimStatusCd :"+claimStatusCd+" claimCount: "+claimCount);
		}

		Map<String, Integer> assignedClaimsCountMap = getAssignedCounts(userName, facilitySet, visnOnlyQuery);
	    userStationDetails = generateResponse(facilitySet,claimCountsList,assignedClaimsCountMap);
	    
	    // setting the visns and the privacy restrictions
	    userStationDetails.setVisns(visnSetString);
	    userStationDetails.setPrivacyRestrictions(getPrivacyRestrictions(userName));
	    
		return userStationDetails;
	}

	/**
	 * @param facilitySet
	 * @param claimCountList
	 * @param assignedClaimsCountMap
	 * @return
	 */
	public UserStationDetails generateResponse(Set<String> facilitySet, List<ClaimCounts> claimCountList, Map<String, Integer> assignedClaimsCountMap) {
		int totalNumberOfClaimsAwaiting = 0;
		int totalNumberOfClaimsInProcess = 0;
		int totalNumberOfClaimsRejected = 0;

		UserStationDetails userStationDetails = new UserStationDetails();

		List<ClaimCountDetails> claimCountDetailsList = new ArrayList<ClaimCountDetails>();

		for( String facility: facilitySet ) {
			logger.debug("generateResponse() facility is : "+facility);	
			ClaimCountDetails claimCountDetails = new ClaimCountDetails();
			
			if( facility == null )
			claimCountDetails.setStationNumber("VISN");
			else
			claimCountDetails.setStationNumber(facility);
			
			logger.debug("generateResponse() assignedClaimsCountMap.get(facility)"+assignedClaimsCountMap.get(facility));
			
			for ( ClaimCounts claimCount: claimCountList ) {
				if( (facility == null && claimCount.getVaFacilityCd() == null) ||
					(facility != null && claimCount.getVaFacilityCd() != null && facility.equals(claimCount.getVaFacilityCd()))) {
					
			logger.debug(" claimCount.getVaFacilityCd() is : "+claimCount.getVaFacilityCd());
			logger.debug(" claimCount.getClaimStatusCd() is : "+claimCount.getClaimStatusCd());
			
					switch( claimCount.getClaimStatusCd() ) {
					case "INPROCESS":
						claimCountDetails.setNumberOfClaimsInProcess(claimCount.getClaimCount());
						totalNumberOfClaimsInProcess= totalNumberOfClaimsInProcess + claimCount.getClaimCount();
						break;
					case "ESTABLISH":
						claimCountDetails.setNumberOfClaimsAwaiting(claimCount.getClaimCount());
						totalNumberOfClaimsAwaiting = totalNumberOfClaimsAwaiting + claimCount.getClaimCount();
						break;
					case "REJECTED":
						claimCountDetails.setNumberOfClaimsRejected(claimCount.getClaimCount());
						totalNumberOfClaimsRejected = totalNumberOfClaimsRejected + claimCount.getClaimCount();
						break;
					default:
					}
				}
			}
			claimCountDetailsList.add(claimCountDetails);
		}

		logger.debug(" calculating the total number of assigned claims from assignedClaimsCountMap :"+assignedClaimsCountMap);
		
		userStationDetails.setclaimCountDetails(claimCountDetailsList);
		userStationDetails.setTotalNumberOfClaimsAwaiting(totalNumberOfClaimsAwaiting);
		userStationDetails.setTotalNumberOfClaimsInProcess(totalNumberOfClaimsInProcess);
		userStationDetails.setTotalNumberOfClaimsRejected(totalNumberOfClaimsRejected);		

		logger.debug(" userStationDetails are :"+userStationDetails);
		return userStationDetails;
	}

	/**
	 * @param userName
	 * @param userFacilities
	 * @param visnOnlyQuery
	 * @return
	 */
	public Map<String, Integer> getAssignedCounts(String userName, Set<String> userFacilities, String visnOnlyQuery ) {
		
		String userFacilitiesString = String.join(",", userFacilities);
		logger.info("UserFacilityString value is : "+userFacilitiesString);
		String assignedClaimsCountsQuery = "SELECT c.va_facility_cd, count(c.claim_index) as claim_count "+
			    "FROM fpps_owner.ws_fac_status c   WHERE c.claim_index IN "+ 
			    "(SELECT fcr2.claim_index  "+
			    "FROM fpps_owner.fee_claim_routing fcr2 "+ 
			    "WHERE (fcr2.claim_index, fcr2.transfer_date) IN "+ 
			    "(SELECT fcr.claim_index, MAX(fcr.transfer_date) "+ 
			    "FROM fpps_owner.fee_claim_routing fcr  "+
			    "WHERE fcr.claim_index IN   (SELECT DISTINCT fcr1.claim_index "+ 
			    "FROM fpps_owner.fee_claim_routing fcr1  "+
			    "WHERE fcr1.transferred_to = '"+userName+"' or fcr1.transfer_to_user = '"+userName+"') "+ 
			    "GROUP BY fcr.claim_index)  "+
			    "AND (fcr2.transferred_to = '"+userName+"' or fcr2.transfer_to_user = '"+userName+"')) "+ 
			    "AND (c.va_facility_cd IN ("+userFacilitiesString+") "+visnOnlyQuery+" )"+ 
			    "AND c.claim_status_cd != 'COMPLETE'  "+
			    "GROUP By c.va_facility_cd order by c.va_facility_cd";
			           
		List<Map<String, Object>> rows = jdbcTemplate.queryForList(assignedClaimsCountsQuery);
		logger.info("assignedClaimsCountsQuery is :"+assignedClaimsCountsQuery);
		logger.info("number of rows selected are : "+rows.size());

		Map<String, Integer> assignedCounts = new HashMap<String,Integer>();
		for (Map<String, Object> rs : rows) {
			logger.info("rs is: "+rs.toString());
			String vaFacilityCd = (String)rs.get("VA_FACILITY_CD");
			int claimCount = ((java.math.BigDecimal)rs.get("CLAIM_COUNT")).intValue();
		assignedCounts.put(vaFacilityCd,claimCount);
		}
		
		// Adding counts as zero for the facilities with no assigned claims
		userFacilities.forEach((userFacility)->{
			if( !assignedCounts.containsKey(userFacility)){
				// Setting claim counts to 0
				assignedCounts.put(userFacility,0);
			}
		});
		
        return assignedCounts;
	}
	
/**
 * @param userFacilities
 * @param userName
 * @return
 */
public Set<Integer> getVisnCds(StringBuilder userFacilities, String userName ) {
		logger.info("UserFacilityString value is : "+userFacilities);
		String getVisnCdsQuery = "select distinct(f.visn_id_cd) as visn_cd "  
             +"from fpps_owner.va_facility f, user_role_usages uru, app_user au, app_role ar "  
             +"where f.va_facility_cd = uru.va_facility_cd  "
             +"and au.app_user_id = uru.app_user_id   "
             +"and ar.app_role_id = uru.app_role_id "
             +"and au.user_name='"+userName+"' and (ar.role_name='FEE_VISN_PGM_MANAGER' or ar.role_name='ADMIN' or ar.role_name='READ_ONLY') "
             +"and f.va_facility_cd IN ("+userFacilities+") ";
			           
		List<Map<String, Object>> rows = jdbcTemplate.queryForList(getVisnCdsQuery);
		logger.info("getVisnCdsQuery is :"+getVisnCdsQuery);
		logger.info("number of rows selected are : "+rows.size());
		Set<Integer> visnCdSet = new HashSet<Integer>();
		for ( Map<String, Object> rs : rows) {
			logger.info("rs is: "+rs.toString());
		int visnId = ((java.math.BigDecimal)rs.get("VISN_CD")).intValue();
		visnCdSet.add(visnId);
		}
		logger.debug("visnCdSet is :"+visnCdSet);
        return visnCdSet;
	}


/**
 * @param userName
 * @return
 */
public String getPrivacyRestrictions(String userName ) {
	logger.info("getPrivacyRestrictions() value is : "+userName);
	String privacyRestrictionsQuery = "SELECT p2p.person_id FROM fpps_owner.privacy_to_person p2p WHERE upper(p2p.user_name) = upper('"+userName+"')";
		           
	List<Map<String, Object>> rows = jdbcTemplate.queryForList(privacyRestrictionsQuery);
	logger.info("privacyRestrictionsQuery is :"+privacyRestrictionsQuery);
	logger.info("number of rows selected are : "+rows.size());
	Set<String> personIdSet = new HashSet<String>();
	for ( Map<String, Object> rs : rows) {
		logger.info("rs is: "+rs.toString());
	personIdSet.add((String)rs.get("person_id"));
	}
	logger.debug("personIdSet is :"+personIdSet);
	String privacyRestrictions = String.join(",", personIdSet);
	logger.debug("personIdString is :"+privacyRestrictions);
    return privacyRestrictions;
}


}
