/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IUnmatchedReconciliationRepositoryTemplate;
import gov.va.med.fee.model.request.UnmatchedReconciliationRequest;
import gov.va.med.fee.model.response.UnmatchedClaimPaymentsResponse;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public class UnmatchedReconciliationRepositoryTemplateImpl implements IUnmatchedReconciliationRepositoryTemplate {

	private static HashMap<String, String> searchParametersToSet = new HashMap<String, String>();

	static int classCounter = 0;

	private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
	}

	@Override
	public List<UnmatchedClaimPaymentsResponse> getClaimPaymentInformation(
			UnmatchedReconciliationRequest unmatchedReconciliationRequest) {

		StringBuilder sql = getSqlScript(unmatchedReconciliationRequest);

		List<UnmatchedClaimPaymentsResponse> unmatchedClaimPaymentsList = new ArrayList<UnmatchedClaimPaymentsResponse>();

		try {
			unmatchedClaimPaymentsList = namedParameterJdbcTemplate.query(sql.toString(), searchParametersToSet,
					new ResultSetExtractor<List<UnmatchedClaimPaymentsResponse>>() {

						@Override
						public List<UnmatchedClaimPaymentsResponse> extractData(ResultSet arg0)
								throws SQLException, DataAccessException {
							List<UnmatchedClaimPaymentsResponse> unmatchedClaimPaymentsList = new ArrayList<UnmatchedClaimPaymentsResponse>();
							UnmatchedClaimPaymentsResponse unmatchedClaimPaymentsResponse = null;

							while (arg0.next()) {
								unmatchedClaimPaymentsResponse = new UnmatchedClaimPaymentsResponse();

								unmatchedClaimPaymentsResponse
										.setFeeClaimPaymentId(arg0.getString("FEE_CLAIM_PAYMENT_ID"));
								unmatchedClaimPaymentsResponse.setFeeInvoice(arg0.getString("FEE_INVOICE_NUMBER"));
								unmatchedClaimPaymentsResponse.setClaimId(arg0.getLong("CLAIM_INDEX"));
								unmatchedClaimPaymentsResponse.setDatePaid(arg0.getString("DATE_MODIFIED"));
								unmatchedClaimPaymentsResponse.setAmoungBilled(arg0.getString("BILLED_AMOUNT"));
								unmatchedClaimPaymentsResponse.setAmountpaid(arg0.getString("PAID_AMOUNT"));
								unmatchedClaimPaymentsResponse.setReconType(arg0.getString("TRANSACTION_TYPE_CODE"));
								unmatchedClaimPaymentsResponse
										.setDrgCcode(arg0.getString("DIAGNOSIS_RELATED_GROUP_CODE"));
								unmatchedClaimPaymentsResponse
										.setDegWeight(arg0.getString("DIAGNOSIS_RELATED_GROUP_WEIGHT"));
								unmatchedClaimPaymentsResponse.setInvoiceDate(arg0.getString("FEE_INVOICE_DATE"));
								unmatchedClaimPaymentsResponse
										.setResolutionStatus(arg0.getString("RESOLUTION_STATUS_CODE"));

								unmatchedClaimPaymentsList.add(unmatchedClaimPaymentsResponse);
							}
							return unmatchedClaimPaymentsList;
						}
					});
		} catch (Exception e) {
			e.printStackTrace();
		}

		classCounter = 0;
		searchParametersToSet.clear();
		return unmatchedClaimPaymentsList;
	}

	public StringBuilder getSqlScript(UnmatchedReconciliationRequest unmatchedReconciliationRequest) {

		StringBuilder sqlStr = new StringBuilder();

		sqlStr.append("select fcp.* from FEE_CLAIM_PAYMENTS fcp where fcp.DATE_CREATED is not null");

		if (unmatchedReconciliationRequest.getReconciliationType().equalsIgnoreCase("ALL")
				|| unmatchedReconciliationRequest.getReconciliationType().equalsIgnoreCase("all")) {
		} else if (unmatchedReconciliationRequest.getReconciliationType() != null
				&& unmatchedReconciliationRequest.getReconciliationType() != ""
				&& !unmatchedReconciliationRequest.getReconciliationType().equals("%")) {
			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getReconciliationType(),
					" and fcp.TRANSACTION_TYPE_CODE ", ""));
			// sqlStr.append(" and fcp.transactionTypeCode = '" +
			// unmatchedReconciliationRequest.getReconciliationType() + "'");
		}

		if (unmatchedReconciliationRequest.getBilledAmount() != null
				&& unmatchedReconciliationRequest.getBilledAmount() != ""
				&& !unmatchedReconciliationRequest.getBilledAmount().equals("%")
				&& !unmatchedReconciliationRequest.getBilledAmount().equals("_")) {

			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getBilledAmount(),
					" and fcp.BILLED_AMOUNT ", ""));
		}

		if (unmatchedReconciliationRequest.getPaidAmount() != null
				&& unmatchedReconciliationRequest.getPaidAmount() != ""
				&& !unmatchedReconciliationRequest.getPaidAmount().equals("%")
				&& !unmatchedReconciliationRequest.getPaidAmount().equals("_")) {

			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getPaidAmount(),
					" and fcp.PAID_AMOUNT ", ""));
		}

		if (unmatchedReconciliationRequest.getDrgWeight() != null && unmatchedReconciliationRequest.getDrgWeight() != ""
				&& !unmatchedReconciliationRequest.getDrgWeight().equals("%")
				&& !unmatchedReconciliationRequest.getDrgWeight().equals("_")) {

			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getDrgWeight(),
					" and fcp.DIAGNOSIS_RELATED_GROUP_WEIGHT ", ""));
		}

		if (unmatchedReconciliationRequest.getFeeInvoicenumber() != null
				&& unmatchedReconciliationRequest.getFeeInvoicenumber() != ""
				&& !unmatchedReconciliationRequest.getFeeInvoicenumber().equals("%")
				&& !unmatchedReconciliationRequest.getFeeInvoicenumber().equals("_")) {

			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getFeeInvoicenumber(),
					" and fcp.FEE_INVOICE_NUMBER ", ""));
		}

		if (unmatchedReconciliationRequest.getDrgCode() != null && unmatchedReconciliationRequest.getDrgCode() != ""
				&& !unmatchedReconciliationRequest.getDrgCode().equals("%")
				&& !unmatchedReconciliationRequest.getDrgCode().equals("_")) {

			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getDrgCode(),
					" and fcp.DIAGNOSIS_RELATED_GROUP_CODE ", ""));
		}

		if (unmatchedReconciliationRequest.getResolutionStatus().equalsIgnoreCase("ALL")
				|| unmatchedReconciliationRequest.getResolutionStatus().equalsIgnoreCase("all")) {
		} else if (unmatchedReconciliationRequest.getResolutionStatus() != null
				&& unmatchedReconciliationRequest.getResolutionStatus() != ""
				&& !unmatchedReconciliationRequest.getResolutionStatus().equals("%")
				&& !unmatchedReconciliationRequest.getResolutionStatus().equals("_")) {

			sqlStr.append(appendSqlStringParameters(unmatchedReconciliationRequest.getResolutionStatus(),
					" and fcp.RESOLUTION_STATUS_CODE ", ""));
		}

		if (unmatchedReconciliationRequest.getInvoiceDate() != null
				&& unmatchedReconciliationRequest.getInvoiceDate() != ""
				&& !unmatchedReconciliationRequest.getInvoiceDate().equals("%")
				&& !unmatchedReconciliationRequest.getInvoiceDate().equals("_")) {

			DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
			SimpleDateFormat newFormat = new SimpleDateFormat("dd-MMM-yyyy");

			Date invoiceDate;
			try {
				invoiceDate = formatter.parse(unmatchedReconciliationRequest.getInvoiceDate());
				String beginDate = newFormat.format(invoiceDate);

				sqlStr.append(" AND fcp.FEE_INVOICE_DATE = '" + beginDate + "'");
			} catch (ParseException e) {
				e.printStackTrace();
			}

		}

		return sqlStr;

	}

	private static String appendSqlStringParameters(String searchParam, String prefix, String suffix) {
		String ret = "";
		String param = "p" + classCounter++;

		if ((searchParam != null) && !searchParam.trim().equals("") && !searchParam.trim().equals("%")
				&& !searchParam.trim().equals("_")) {
			if ((searchParam.trim().indexOf("%") >= 0) || (searchParam.trim().indexOf("_") >= 0)) {
				ret += (" " + prefix + " LIKE :" + param + " " + suffix);
				param = param.replace("\\s", "");
				searchParametersToSet.put(param, searchParam.toUpperCase());
			} else {
				ret += (" " + prefix + " = :" + param + " " + suffix);
				param = param.replace("\\s", "");
				searchParametersToSet.put(param, searchParam.toUpperCase());
			}
		}

		return ret;

	}

}
