package gov.va.med.fee.dao.impl;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.domain.fee.Claim;
import gov.va.med.fee.dao.IRerouteClaimsRepositoryTemplate;

@Repository
public class RerouteClaimsRepositoryTemplate implements IRerouteClaimsRepositoryTemplate {
	private static final Logger logger = LogManager.getLogger(RerouteClaimsRepositoryTemplate.class);
	
	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}
		
	// Check if reroute is to a facility with FBCS implementation
	public List<String> findVaImplementationList(String facilityId) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
		String today = dateFormat.format(new Date());
		String sqlToday = new StringBuilder("to_date('").append(today).append("','MM/DD/YYYY')").toString();
		
		String sql = new StringBuilder("select va_imp_type_cd from fpps_owner.va_implementation where va_facility_cd = ?")
				.append(" and va_imp_type_cd is not null").append(" and start_date <= ")
				.append(sqlToday).append(" and (end_date is null or end_date >= ").append(sqlToday).append(")")
				.toString();
		
		List<String> vaImpTypes = new ArrayList<>();
		try {
			vaImpTypes = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setString(1, facilityId);
				}
			}, new RowMapper<String>() {
				public String mapRow(ResultSet rs, int rowNum) throws SQLException {
					// retrieve the facility ID and add to list
					String code = rs.getString("VA_IMP_TYPE_CD");
					return code;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.debug("findVaImplementationList() -" + vaImpTypes);
		return vaImpTypes;
	}
	
	//calling PL/SQL in programtracking_reroute
	public boolean transferToNonFPPS(Claim claim, String username, String visn, String facility, String reason,	String comments) {
		CallableStatement cs = null;
		boolean status = false;
		try {			
			cs = jdbcTemplate.getDataSource().getConnection().prepareCall("{call programtracking_reroute (?,?,?,?,?,?)}");
			cs.setLong(1, claim.getClaimIndex());
			cs.setString(2, username);
			cs.setString(3, visn);
			cs.setString(4, facility);
			cs.setString(5, reason);
			cs.setString(6, comments);
			cs.execute();
			status = true;
		} catch (Exception e) {
			logger.error(e);
			e.printStackTrace();
		} finally {
			try {
				//if (cs != null) {
					cs.close();
				//}
			} catch (Exception e) {
				logger.error(e);
			}
		}

		return status;
	}
}
