package gov.va.med.fee.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IRejectionHistoryRepositoryTemplate;
import gov.va.med.fee.model.response.ClaimRejectionHistoryResponse;

/**
 * @author Alejandro Barrero
 * 
 * @Modified by Vamsi Krishna Gangarapu modified the return type to point to
 *           {@link ClaimRejectionHistoryResponse}
 */
@Repository
public class RejectionHistoryRepositoryTemplate implements IRejectionHistoryRepositoryTemplate {
	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.IRejectionHistoryRepositoryTemplate#findRejectionHistory(java.lang.String, java.lang.Long)
	 */
	/*@Override
	public List<ClaimRejectionHistoryResponse> findRejectionHistory(String claimQueueTypeCode, Long claimIndex) {
		String sql = "select t.enqueue_date, t.created_by, a.description,  t.enqueue_comments, t.modified_by, t.outcome, t.dequeue_comments from claim_queue t, adjustment_reason a where t.reason = a.adjustment_reason_cd and t.claim_queue_type_cd= ? and t.claim_index= ? order by t.enqueue_date DESC";
		List<ClaimRejectionHistoryResponse> rejectionHistoryList = new ArrayList<ClaimRejectionHistoryResponse>();
		try {
			rejectionHistoryList = jdbcTemplate.query(sql, new Object[] { claimQueueTypeCode, claimIndex },
					new ResultSetExtractor<List<ClaimRejectionHistoryResponse>>() {
						@Override
						public List<ClaimRejectionHistoryResponse> extractData(ResultSet rs)
								throws SQLException, DataAccessException {
							List<ClaimRejectionHistoryResponse> rejectionHistoryList = new ArrayList<ClaimRejectionHistoryResponse>();
							ClaimRejectionHistoryResponse rejectionHistory = null;
							while (rs.next()) {
								rejectionHistory = new ClaimRejectionHistoryResponse();
								
								rejectionHistory.setDate(rs.getDate("ENQUEUE_DATE"));
								rejectionHistory.setExplanation(rs.getString("ENQUEUE_COMMENTS"));
								rejectionHistory.setOutcome(rs.getString("OUTCOME"));
								rejectionHistory.setReason(rs.getString("DESCRIPTION"));
								rejectionHistory.setRejectedBy(rs.getString("CREATED_BY"));
								rejectionHistory.setReviewedBy(rs.getString("MODIFIED_BY"));
								rejectionHistory.setReviewerComents(rs.getString("DEQUEUE_COMMENTS"));
								rejectionHistoryList.add(rejectionHistory);
							}
							return rejectionHistoryList;
						}
					});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rejectionHistoryList;
	}*/
	
	//other way of getting the rejection history list.
	//Need to take care of the date type with this method
	
	/*@Override
	public List<ClaimRejectionHistoryResponse> findRejectionHistory(String claimQueueTypeCode, Long claimIndex) {
		String sql = "select t.enqueue_date, t.created_by, a.description,  t.enqueue_comments, t.modified_by, t.outcome, t.dequeue_comments from claim_queue t, adjustment_reason a where t.reason = a.adjustment_reason_cd and t.claim_queue_type_cd= ? and t.claim_index= ? order by t.enqueue_date DESC";
		List<ClaimRejectionHistoryResponse> rejectionHistoryList = new ArrayList<ClaimRejectionHistoryResponse>();;
			List<Map<String, Object>> rows = jdbcTemplate.queryForList(sql,
					new Object[] { claimQueueTypeCode, claimIndex });

			ClaimRejectionHistoryResponse rejectionHistory = null;
			for (Map<String, Object> rs : rows) {
				rejectionHistory = new ClaimRejectionHistoryResponse();
				
				rejectionHistory.setDate((Date) rs.get("ENQUEUE_DATE"));
				rejectionHistory.setExplanation((String) rs.get("ENQUEUE_COMMENTS"));
				rejectionHistory.setOutcome((String) rs.get("OUTCOME"));
				rejectionHistory.setReason((String) rs.get("DESCRIPTION"));
				rejectionHistory.setRejectedBy((String) rs.get("CREATED_BY"));
				rejectionHistory.setReviewedBy((String) rs.get("MODIFIED_BY"));
				rejectionHistory.setReviewerComents((String) rs.get("DEQUEUE_COMMENTS"));
				rejectionHistoryList.add(rejectionHistory);
			}
			return rejectionHistoryList;

		}*/
	
	@Override
	public List<ClaimRejectionHistoryResponse> findRejectionHistory(String claimQueueTypeCode, Long claimIndex) {
		String sql = "select t.enqueue_date, t.created_by, a.description,  t.enqueue_comments, t.modified_by, t.outcome, t.dequeue_comments from claim_queue t, adjustment_reason a where t.reason = a.adjustment_reason_cd and t.claim_queue_type_cd= ? and t.claim_index= ? order by t.enqueue_date DESC";
		List<ClaimRejectionHistoryResponse> rejectionHistoryList = new ArrayList<ClaimRejectionHistoryResponse>();
		try {
			rejectionHistoryList = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					//new Object[] { claimQueueTypeCode, claimIndex }
					
					arg0.setString(1, claimQueueTypeCode);
					arg0.setLong(2, claimIndex);
					
				}
			},
					new ResultSetExtractor<List<ClaimRejectionHistoryResponse>>() {
						@Override
						public List<ClaimRejectionHistoryResponse> extractData(ResultSet rs)
								throws SQLException, DataAccessException {
							List<ClaimRejectionHistoryResponse> rejectionHistoryList = new ArrayList<ClaimRejectionHistoryResponse>();
							ClaimRejectionHistoryResponse rejectionHistory = null;
							while (rs.next()) {
								rejectionHistory = new ClaimRejectionHistoryResponse();
								
								rejectionHistory.setDate(rs.getDate("ENQUEUE_DATE"));
								rejectionHistory.setExplanation(rs.getString("ENQUEUE_COMMENTS"));
								rejectionHistory.setOutcome(rs.getString("OUTCOME"));
								rejectionHistory.setReason(rs.getString("DESCRIPTION"));
								rejectionHistory.setRejectedBy(rs.getString("CREATED_BY"));
								rejectionHistory.setReviewedBy(rs.getString("MODIFIED_BY"));
								rejectionHistory.setReviewerComents(rs.getString("DEQUEUE_COMMENTS"));
								rejectionHistoryList.add(rejectionHistory);
							}
							return rejectionHistoryList;
						}
					});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rejectionHistoryList;
	}
	}
