package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IRejectedClaimRepository;
import gov.va.med.fee.model.response.ClaimRejectedResponse;
import gov.va.med.fee.model.response.ClaimRejectionHistory;

@Repository
public class RejectedClaimRepositoryImpl implements IRejectedClaimRepository{

	private static final Logger logger = LogManager.getLogger(RejectedClaimRepositoryImpl.class);

	private JdbcTemplate jdbcTemplate;
	
	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}
	
	public List<ClaimRejectedResponse> findRejectedClaims(List<String> activeStationList, List<Long> visnsList, List<String> privacyRestrictionsList, String claimStatusCode){
		logger.info("findRejectedClaims:");
		String privacyRestrictions = String.join(",", privacyRestrictionsList).replaceAll("([^,]+)", "\'$1\'");
		Long visns = (visnsList !=null ? new Long(Arrays.toString(visnsList.toArray()).replaceAll("[\\[\\]]", "")) : null);
		String activeStations = String.join(",", activeStationList).replaceAll("([^,]+)", "\'$1\'");

		List<ClaimRejectedResponse> claimResponsList = new ArrayList<ClaimRejectedResponse>();
		StringBuilder sqlquery = new StringBuilder();
/*		sqlquery.append("select c.*, q.*, ar.description from ws_fac_status c, claim_queue q, adjustment_reason ar ");
		sqlquery.append(" where c.claim_status_cd = 'REJECTED' ");
		sqlquery.append(" and c.claim_index = q.claim_index ");
		sqlquery.append(" and q.reason = ar.adjustment_reason_cd ");
		sqlquery.append(" and q.claim_queue_type_cd = 'REJECTION_APPROVAL' ");
		sqlquery.append(" and q.dequeue_date is null ");
		sqlquery.append(" and (c.va_facility_cd in (");
		sqlquery.append(activeStations);
		sqlquery.append(") ");
		if(visns != null) {
			sqlquery.append(" OR c.visn_id_cd in (");
			sqlquery.append(visns);
			sqlquery.append(")");
		}
		sqlquery.append(")");
		sqlquery.append(" and c.person_id not in (");
		sqlquery.append(privacyRestrictions);
		sqlquery.append(") ");*/
		
		sqlquery.append("select wfs.*, cq.*, ar.description ");
		sqlquery.append(" from ws_fac_status wfs inner join ");
		sqlquery.append("          (Select cq.claim_index, MAX(cq.CLAIM_QUEUE_ID)as maxQueueId ");
		sqlquery.append("           from claim_queue cq ");
		sqlquery.append("           Group by claim_index) maxClaimQ ");
		sqlquery.append(" on wfs.claim_index=maxClaimQ.claim_index "); 
		sqlquery.append(" and wfs.claim_status_cd = 'REJECTED' ");
		sqlquery.append(" and (wfs.va_facility_cd in ( ");
		sqlquery.append(activeStations);
		sqlquery.append(") ");
		if(visns != null) {
			sqlquery.append(" OR wfs.visn_id_cd in (");
			sqlquery.append(visns);
			sqlquery.append(")");
		}
		sqlquery.append(") ");
		sqlquery.append(" and wfs.person_id not in ( ");
		sqlquery.append(privacyRestrictions); 
		sqlquery.append(" ) ");
		sqlquery.append(" inner join claim_queue cq on cq.claim_index = maxClaimQ.claim_index ");
		sqlquery.append(" and cq.CLAIM_QUEUE_ID=maxClaimQ.maxQueueId ");
		sqlquery.append(" and cq.claim_queue_type_cd = 'REJECTION_APPROVAL' ");  
		sqlquery.append(" and cq.dequeue_date is null ");
		sqlquery.append(" left outer join adjustment_reason ar on ar.ADJUSTMENT_REASON_CD = cq.reason ");
		
		SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
		
		claimResponsList = jdbcTemplate.query(sqlquery.toString(),
				new RowMapper<ClaimRejectedResponse>() {

					@Override
					public ClaimRejectedResponse mapRow(ResultSet rs, int rowNum) throws SQLException {

						ClaimRejectedResponse claimRejectedResponse = new ClaimRejectedResponse();
						//removed assignedTo as per change request 596357
						//claimRejectedResponse.setAssignedTo(rs.getString("USER_NAME"));
						claimRejectedResponse.setClaimAmount(rs.getBigDecimal("TOTAL_BILLED_CHARGE"));
						claimRejectedResponse.setClaimDate(dateFormat.format(rs.getDate("DATE_CREATED")));
						claimRejectedResponse.setClaimId(rs.getLong("CLAIM_INDEX"));
						claimRejectedResponse.setClaimStatus(rs.getString("CLAIM_STATUS_CD"));
						claimRejectedResponse.setClaimType(rs.getString("SERVICE_TYPE_CD"));
						claimRejectedResponse.setDateInProcess(dateFormat.format(rs.getDate("DATE_IN_PROCESS")));
						claimRejectedResponse.setFacility(rs.getString("VA_FACILITY_CD"));
						String heroFlag = rs.getString("HERO_FLAG");
						if( heroFlag!= null && (("1").equalsIgnoreCase(heroFlag)))
							claimRejectedResponse.setHero('Y');
							else
								claimRejectedResponse.setHero('N');

						claimRejectedResponse.setLines(rs.getLong("TOTAL_LINES"));
						claimRejectedResponse.setLinesClosed(rs.getLong("LINES_CLOSED"));
						claimRejectedResponse.setProviderName(rs.getString("PROVIDER_NAME"));
						claimRejectedResponse.setSsn(rs.getString("PERSON_ID"));
						claimRejectedResponse.setVeteranName(rs.getString("PATIENT_NAME"));
						claimRejectedResponse.setVisnIdCd(rs.getLong("VISN_ID_CD"));
						
						claimRejectedResponse.setDisapprovedBy(rs.getString("CREATED_BY"));
						
						//temporary fix by changing the data type to String anf fixing the format
						claimRejectedResponse.setDisapprovedDate(dateFormat.format(rs.getDate("DATE_CREATED")));
						claimRejectedResponse.setReason(rs.getString("REASON"));
						claimRejectedResponse.setReasonDesc(rs.getString("ENQUEUE_COMMENTS"));
						claimRejectedResponse.setDisapproversComments(rs.getString("ENQUEUE_COMMENTS"));

						return claimRejectedResponse;
					}
				});

		Map<Long, List<ClaimRejectionHistory>> rejectionHistoryMap = new HashMap<Long, List<ClaimRejectionHistory>>();
		
		for(ClaimRejectedResponse claimRejectedResponse:claimResponsList) {
			//claimRejectedResponse = getClaimDisapprovalReason(claimRejectedResponse);
			long claimIndex = claimRejectedResponse.getClaimId();
			//Avoid db call if the history already been queried for the same claim
			if(rejectionHistoryMap.get(claimIndex) != null) {
				claimRejectedResponse.setRejectionHist(rejectionHistoryMap.get(claimIndex));
			}
			else {
				List<ClaimRejectionHistory> claimRejectionHistoryList = attachRejectionHistory(claimIndex);
				rejectionHistoryMap.put(claimIndex, claimRejectionHistoryList);	
				claimRejectedResponse.setRejectionHist(claimRejectionHistoryList);
			}
		}
		return claimResponsList;
	}
	
/*	private ClaimRejectedResponse getClaimDisapprovalReason(ClaimRejectedResponse claimRejectedResponse) {
		logger.info("findRejectedClaims:");
		long claimIndex = claimRejectedResponse.getClaimId();
		StringBuilder sqlquery = new StringBuilder();
		sqlquery.append("select q.* from claim_queue q ");
		sqlquery.append(" where q.claim_index = ? ");
		sqlquery.append(" and q.claim_queue_type_cd = 'REJECTION_APPROVAL' ");
		sqlquery.append(" and q.dequeue_date is null ");
		sqlquery.append(" order by q.enqueue_date desc ");

		ClaimRejectedResponse claimRejectedResponseDb = jdbcTemplate.query(sqlquery.toString(), new Object[] { claimIndex },
				new ResultSetExtractor<ClaimRejectedResponse>() {

					@Override
					public ClaimRejectedResponse extractData(ResultSet rs) throws SQLException, DataAccessException {
						//ClaimRejectedResponse claimRejectedResponseDb = null;
						while (rs.next()) {
							claimRejectedResponse.setDisapprovedBy(rs.getString("CREATED_BY"));
							claimRejectedResponse.setDisapprovedDate(rs.getDate("DATE_CREATED"));
							claimRejectedResponse.setReason(rs.getString("REASON"));
							claimRejectedResponse.setReasonDesc(getReasonCodeDesc(rs.getString("REASON")));
							claimRejectedResponse.setDisapproversComments(rs.getString("ENQUEUE_COMMENTS"));
						}
						return claimRejectedResponse;
					}

				});	
		
		return claimRejectedResponseDb;
	}

	private String getReasonCodeDesc(String code) {
		String sql = "select rc.description from adjustment_reason rc where rc.adjustment_reason_cd = ?";
		String reasonCodeDesc = jdbcTemplate.queryForObject(sql, new Object[] { code }, String.class);
		return reasonCodeDesc;
	}*/
	
	private List<ClaimRejectionHistory> attachRejectionHistory(long claimIndex) {
		logger.info("attachRejectionHistory:");
		StringBuilder sqlquery = new StringBuilder();
		sqlquery.append("select q.* from claim_queue q ");
		sqlquery.append(" where q.claim_index = ");
		sqlquery.append(claimIndex);
		sqlquery.append(" and q.claim_queue_type_cd = 'REJECTION_APPROVAL' ");
		sqlquery.append(" order by q.enqueue_date desc ");
		
		List<ClaimRejectionHistory> claimRejectionHistoryList = new ArrayList<ClaimRejectionHistory>();
		claimRejectionHistoryList = jdbcTemplate.query(sqlquery.toString(),
				new RowMapper<ClaimRejectionHistory>() {

					@Override
					public ClaimRejectionHistory mapRow(ResultSet rs, int rowNum) throws SQLException {

						ClaimRejectionHistory claimRejectionHistory = new ClaimRejectionHistory();
						claimRejectionHistory.setClaimQueueId(rs.getLong("CLAIM_QUEUE_ID"));
						claimRejectionHistory.setClaimQueueTypeCd(rs.getString("CLAIM_QUEUE_TYPE_CD"));
						claimRejectionHistory.setCreatedBy(rs.getString("CREATED_BY"));
						claimRejectionHistory.setDateCreated(rs.getDate("DATE_CREATED"));
						claimRejectionHistory.setDateModified(rs.getDate("DATE_MODIFIED"));
						claimRejectionHistory.setDequeueComments(rs.getString("DEQUEUE_COMMENTS"));
						claimRejectionHistory.setDequeueDate(rs.getDate("DEQUEUE_DATE"));
						claimRejectionHistory.setEnqueueComments(rs.getString("ENQUEUE_COMMENTS"));
						claimRejectionHistory.setEnqueueDate(rs.getDate("ENQUEUE_DATE"));
						claimRejectionHistory.setModifiedBy(rs.getString("MODIFIED_BY"));
						claimRejectionHistory.setOutcome(rs.getString("OUTCOME"));
						claimRejectionHistory.setReason(rs.getString("REASON"));

						return claimRejectionHistory;
					}
				});		
				
		return claimRejectionHistoryList;
	}
	
/*	public List<ClaimQueue> findRejectedClaimQueue(Set<Long> claimIndexesList) {
		
		//Long claimIndexes = (claimIndexesList !=null ? new Long(Arrays.toString(claimIndexesList.toArray()).replaceAll("[\\[\\]]", "")) : null);
		String claimIndexes = Arrays.toString(claimIndexesList.toArray()).replaceAll("[\\[\\]]", "");
		
		StringBuilder sqlquery = new StringBuilder();
			
		sqlquery.append("select cq.*, c.* ");
		sqlquery.append(" from claim_queue cq inner join ");
		sqlquery.append("      (Select cq.claim_index, MAX(cq.CLAIM_QUEUE_ID)as maxQueueId ");
		sqlquery.append("      from claim_queue cq ");
		sqlquery.append("      Group by claim_index) maxClaimQ ");
		sqlquery.append(" on cq.claim_index = maxClaimQ.claim_index ");
		sqlquery.append(" and cq.CLAIM_QUEUE_ID=maxClaimQ.maxQueueId ");
		sqlquery.append(" inner join claims c on c.claim_index = maxClaimQ.claim_index ");
		sqlquery.append(" and cq.claim_index in ( ");
		sqlquery.append(claimIndexes);
		sqlquery.append(")");
		sqlquery.append(" and cq.claim_queue_type_cd = 'REJECTION_APPROVAL' ");
		sqlquery.append(" and cq.dequeue_date is null ");
		sqlquery.append(" order by cq.enqueue_date desc ");

		List<ClaimQueue> claimQueueList = new ArrayList<ClaimQueue>();
		claimQueueList = jdbcTemplate.query(sqlquery.toString(), new RowMapper<ClaimQueue>() {

					@Override
					public ClaimQueue mapRow(ResultSet rs, int rowNum) throws SQLException {

						ClaimQueue ClaimQueue = new ClaimQueue();
						ClaimQueue.setClaimQueueId(rs.getLong("CLAIM_QUEUE_ID"));
						ClaimQueue.setClaimQueueTypeCd(rs.getString("CLAIM_QUEUE_TYPE_CD"));
						ClaimQueue.setCreatedBy(rs.getString("CREATED_BY"));
						ClaimQueue.setDateCreated(rs.getDate("DATE_CREATED"));
						ClaimQueue.setDateModified(rs.getDate("DATE_MODIFIED"));
						ClaimQueue.setDequeueComments(rs.getString("DEQUEUE_COMMENTS"));
						ClaimQueue.setDequeueDate(rs.getDate("DEQUEUE_DATE"));
						ClaimQueue.setEnqueueComments(rs.getString("ENQUEUE_COMMENTS"));
						ClaimQueue.setEnqueueDate(rs.getDate("ENQUEUE_DATE"));
						ClaimQueue.setModifiedBy(rs.getString("MODIFIED_BY"));
						ClaimQueue.setOutcome(rs.getString("OUTCOME"));
						ClaimQueue.setReason(rs.getString("REASON"));
						
						Claim claim = new Claim();
						claim.setClaimIndex(rs.getLong("CLAIM_INDEX"));
						ClaimQueue.setClaim(claim);

						return ClaimQueue;
					}
				});		
				
		return claimQueueList;
	}*/
}
