/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IReRoutingHistoryRepositoryTemplate;
import gov.va.med.fee.model.response.ReRoutingHistory;

/**
 * 
 * @author Muneshwar Baiah
 *
 */

@Repository
public class ReRoutingHistoryRepositoryImpl implements IReRoutingHistoryRepositoryTemplate {

	
	public static final Logger logger = LogManager.getLogger(ReRoutingHistoryRepositoryImpl.class);

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.IReRoutingHistoryRepositoryTemplate#findReRoutingHistory(java.lang.Long)
	 */
	@Override
	public List<ReRoutingHistory> findReRoutingHistory(Long claimIndex) {

		String sql = "SELECT fcr.transfer_date, fcrr.description,fcr.transferred_to,fcr.transfer_from_user,"
				+ " fcr.transfer_from_visn_cd,fcr.transfer_from_facility_cd,fcr.comments,fcr.transfer_to_user,"
				+ "fcr.transfer_to_visn_cd,fcr.transfer_to_facility_cd,fcr.transfer_initator "
				+ "FROM FEE_CLAIM_ROUTING fcr LEFT JOIN FEE_CLAIM_ROUTINGS_REASON fcrr  ON fcrr.transfer_reason_cd = fcr.transfer_reason_cd WHERE fcr.claim_index=? ORDER BY transfer_date DESC";	
	   logger.info("ReRoutingHistoryRepositoryImpl.findReRoutingHistory() querying the data for the rerouting history using query :"+sql);
		List<ReRoutingHistory> reRoutingHistoryList = new ArrayList<ReRoutingHistory>();
		List<Map<String, Object>> rows = jdbcTemplate.queryForList(sql,
				new Object[] { claimIndex});

		ReRoutingHistory reRoutingHistory = null;
		for (Map<String, Object> rs : rows) {
			   logger.info("ReRoutingHistoryRepositoryImpl.findReRoutingHistory() rs is: "+rs.toString());
				reRoutingHistory = new ReRoutingHistory();
			if( rs.get("TRANSFER_DATE") != null ) {
				Timestamp transferDate = (Timestamp)rs.get("TRANSFER_DATE");
				long transferDateLong = transferDate.getTime();
				Date date = new Date(transferDateLong);
				SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
				reRoutingHistory.setDate(dateFormat.format(date));
			}
			
			if( rs.get("COMMENTS") != null )
			reRoutingHistory.setExplanation((String)rs.get("COMMENTS"));
			
			if( rs.get("DESCRIPTION") != null )
			reRoutingHistory.setReason((String)rs.get("DESCRIPTION"));
			
			// constructing the transferTo response based on the format VISN:/FAC:/USER:
			StringBuilder transferredTo = new StringBuilder();
			transferredTo.append("VISN:");
			
			if ( rs.get("TRANSFER_TO_VISN_CD") != null )
				transferredTo.append((String)rs.get("TRANSFER_TO_VISN_CD"));
			else
				transferredTo.append("");
			
			transferredTo.append("/FAC:");
			
			if ( rs.get("TRANSFER_TO_FACILITY_CD") != null )
			transferredTo.append((String)rs.get("TRANSFER_TO_FACILITY_CD"));
			else
				transferredTo.append("");
			
			transferredTo.append("/USER:");
			
			if ( rs.get("TRANSFER_TO_USER") != null )
			transferredTo.append((String)rs.get("TRANSFER_TO_USER"));
			else
				transferredTo.append("");
			
			StringBuilder transferredFrom = new StringBuilder();
			transferredFrom.append("VISN:");
			
			if ( rs.get("TRANSFER_FROM_VISN_CD") != null )
			transferredFrom.append((String)rs.get("TRANSFER_FROM_VISN_CD"));
			else
				transferredTo.append("");
			
			transferredFrom.append("/FAC:");
			
			if ( rs.get("TRANSFER_FROM_FACILITY_CD") != null )
			transferredFrom.append((String)rs.get("TRANSFER_FROM_FACILITY_CD"));
			else
				transferredTo.append("");
			
			transferredFrom.append("/USER:");
			
			if ( rs.get("TRANSFER_FROM_USER") != null )
			transferredFrom.append((String)rs.get("TRANSFER_FROM_USER"));
			else
				transferredTo.append("");
			
			reRoutingHistory.setTransferredTo(transferredTo);
			reRoutingHistory.setTransferredFrom(transferredFrom);
			
			if( rs.get("TRANSFER_INITATOR") != null )
			reRoutingHistory.setTransferredBy((String)rs.get("TRANSFER_INITATOR"));
			reRoutingHistoryList.add(reRoutingHistory);
		}
		return reRoutingHistoryList;

	}

}
