package gov.va.med.fee.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.PrintedClaim;
import gov.va.med.fee.dao.IPrintedClaimRepository;


@Repository
public class PrintedClaimRepositoryImpl implements IPrintedClaimRepository {
	private static final Logger logger = LogManager.getLogger(PrintedClaimRepositoryImpl.class);
	
	private JdbcTemplate jdbcTemplate;

	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public void createPrintedClaimEntry(List<Long> list, String appUserName) {
		
		String sql = new String("insert into printed_claim(printed_claim_id, claim_index, created_by, date_created)"
						+ " values(fpps_owner.mig.nextVal, ?, ?, sysdate)");
  
		for(Long index: list) {
			jdbcTemplate.update(sql, index, appUserName);			
			logger.debug("Created Record Id = " + index.toString() + " AppUserName = " + appUserName);
		}		
		
		
		/*String index = null;
		try {
			Iterator<String> iter = list.iterator();
			while (iter.hasNext()) {
				index = iter.next();
				PreparedStatement stmt = connection.prepareStatement(sql);
				stmt.setLong(1, Long.parseLong(index));
				stmt.setString(2, appUser.getUserName());

				stmt.executeUpdate();
				stmt.close();
			}
		} catch (SQLException e) {
			logger.error("Error: " + e.getMessage() + " - Could not insert printed claim index: " + index);
		
		} finally {
			try {
				c.close();
			} catch (SQLException e) {
				logger.error(e);
			}
		}*/
	}
	
	@Override
	public PrintedClaim findPrintedClaim(long claimIndex) {
		String sql = "select * from PRINTED_CLAIM pc where pc.CLAIM_INDEX = ? order by DATE_CREATED asc";
		
		List<PrintedClaim> printedClaims = new ArrayList<>();
		try {
			printedClaims = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, claimIndex);
				}
			}, new RowMapper<PrintedClaim>() {

				PrintedClaim printedClaim = new PrintedClaim();
				Claim claim = null;
				
				public PrintedClaim mapRow(ResultSet rs, int rowNum) throws SQLException {
					printedClaim = new PrintedClaim();
					claim = new Claim();
					printedClaim.setPrintedClaimId(rs.getLong("PRINTED_CLAIM_ID"));
					printedClaim.setCreatedBy(rs.getString("CREATED_BY"));
					printedClaim.setDateCreated(rs.getDate("DATE_CREATED"));
					claim.setClaimIndex(claimIndex);
					printedClaim.setClaim(claim);
								
					return printedClaim;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return (printedClaims != null && printedClaims.size() > 0) ? printedClaims.get(0) : null;
	}
}
