/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.fee.dao.ILineItemsRepositoryTemplate;
import gov.va.med.fee.model.request.LineItemsRequest;
import gov.va.med.fee.model.request.SeqDetailRequest;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public class LineItemsRepositoryTemplateImpl implements ILineItemsRepositoryTemplate {

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.ILineItemsRepositoryTemplate#findLineItemsInfo(java.lang.Long)
	 */
	@Override
	public List<LineItemsRequest> findLineItemsInfo(Long claimIndex) {

		String sql = "select cp.claim_proc_id, cp.claim_procedure_seq, cp.proc_code, cp.revenue_cd, cp.service_from_date, cp.service_to_date, cp.billed_amount, "
				+ "cp.proc_code_desc, cp.diag_pointer, cp.billed_units, cp.modifier1, cp.modifier2, cp.modifier3, cp.modifier4, cpay.TREASURY_PAYMENT_DATE as payment_date, "
				+ "cpr.paid_amount, cpay.payment_tracking_number, "
				+ "(SELECT ti.tooth_code FROM TOOTH_INFO ti WHERE ti.claim_index= ? AND cp.claim_proc_id = ti.claim_proc_id) as toothCode, "
				+ "(SELECT ti.tooth_surface FROM TOOTH_INFO ti WHERE ti.claim_index=  ? AND cp.claim_proc_id = ti.claim_proc_id) as toothSurface, "
				+ "(SELECT ti.tooth_surface_cd2 FROM TOOTH_INFO ti WHERE ti.claim_index= ? AND cp.claim_proc_id = ti.claim_proc_id) as toothSurfaceCd2, "
				+ "(SELECT ti.tooth_surface_cd3 FROM TOOTH_INFO ti WHERE ti.claim_index= ? AND cp.claim_proc_id = ti.claim_proc_id) as toothSurfaceCd3, "
				+ "( SELECT ti.tooth_surface_cd4 FROM TOOTH_INFO ti WHERE ti.claim_index= ? AND cp.claim_proc_id = ti.claim_proc_id) as toothSurfaceCd4, "
				+ "(SELECT ti.tooth_surface_cd5 FROM TOOTH_INFO ti WHERE ti.claim_index= ? AND cp.claim_proc_id = ti.claim_proc_id) as toothSurfaceCd5, "
				+ "cp.oral_cavity_cd, cp.line_status from claim_procedure cp, claim_payment cpay, claim_proc_recon cpr "
				+ "where cp.claim_index = ? and cp.claim_proc_id = cpr.claim_proc_id(+) and cpr.claim_payment_id = cpay.claim_payment_id(+) "
				+ "order by cp.claim_procedure_seq, cpay.payment_tracking_number";
				
		
		List<LineItemsRequest> lineItemsRequests = new ArrayList<>();
		try {
			lineItemsRequests = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, claimIndex);
					arg0.setLong(2, claimIndex);
					arg0.setLong(3, claimIndex);
					arg0.setLong(4, claimIndex);
					arg0.setLong(5, claimIndex);
					arg0.setLong(6, claimIndex);
					arg0.setLong(7, claimIndex);
				}
			}, new RowMapper<LineItemsRequest>() {

				public LineItemsRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
					LineItemsRequest lineItemRequest = new LineItemsRequest();
					lineItemRequest.setClaimProcId(rs.getBigDecimal("CLAIM_PROC_ID"));
					lineItemRequest.setClaimProcedureSequence(rs.getBigDecimal("CLAIM_PROCEDURE_SEQ"));
					lineItemRequest.setProcCode(rs.getString("PROC_CODE"));
					lineItemRequest.setRevenueCode(rs.getString("REVENUE_CD"));
					lineItemRequest.setServiceFromDate(rs.getTimestamp("SERVICE_FROM_DATE"));
					lineItemRequest.setServiceToDate(rs.getTimestamp("SERVICE_TO_DATE"));
					lineItemRequest.setBilledAmount(rs.getBigDecimal("BILLED_AMOUNT"));
					lineItemRequest.setProcCodeDesc(rs.getString("PROC_CODE_DESC"));
					lineItemRequest.setDiagPointer(rs.getString("DIAG_POINTER"));
					lineItemRequest.setBilledUnits( rs.getBigDecimal("BILLED_UNITS"));
					lineItemRequest.setModifier1(rs.getString("MODIFIER1"));
					lineItemRequest.setModifier2(rs.getString("MODIFIER2"));
					lineItemRequest.setModifier3(rs.getString("MODIFIER3"));
					lineItemRequest.setModifier4(rs.getString("MODIFIER4"));
					lineItemRequest.setPaymentDate(rs.getTimestamp("PAYMENT_DATE"));
					lineItemRequest.setPaidAmount(rs.getBigDecimal("PAID_AMOUNT"));
					lineItemRequest.setPaymentTrackingnumber(rs.getString("PAYMENT_TRACKING_NUMBER"));
					lineItemRequest.setToothCode(rs.getString("TOOTHCODE"));
					lineItemRequest.setToothSurface(rs.getString("TOOTHSURFACE"));
					lineItemRequest.setToothSurfaceCd2(rs.getString("TOOTHSURFACECD2"));
					lineItemRequest.setToothSurfaceCd3(rs.getString("TOOTHSURFACECD3"));
					lineItemRequest.setToothSurfaceCd4(rs.getString("TOOTHSURFACECD4"));
					lineItemRequest.setToothSurfaceCd5(rs.getString("TOOTHSURFACECD5"));
					lineItemRequest.setOralCavityCd(rs.getString("ORAL_CAVITY_CD"));
					lineItemRequest.setLineStatus(rs.getString("LINE_STATUS"));
					//lineItemsRequest.add(lineItemRequest);
					return lineItemRequest;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return lineItemsRequests;

	}
		
	@Override
	public SeqDetailRequest getCARCDetail(long sequenceNumber, long claimIndex) {
		
		String sql = "select cp.claim_procedure_seq,  adjustment_reason_cd adjustment_reason_code_1,  adjustment_amount as adjustment_amount_1, cpr.paid_amount "
				+ "from claim_procedure cp, claim_proc_recon cpr, claim_proc_rec_adjust cadj "
				+ "where cp.claim_index = ? and cp.claim_procedure_seq = ? "
				+ "and cp.claim_proc_id = cpr.claim_proc_id "
				+ "and cpr.claim_proc_rec_id = CADJ.CLAIM_PROC_REC_ID(+) "
				+ "order by  claim_procedure_seq ";
		
		SeqDetailRequest seqDetailRequest = new SeqDetailRequest();
		try {
			seqDetailRequest = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, claimIndex);
					arg0.setLong(2, sequenceNumber);
				}
			}, new ResultSetExtractor<SeqDetailRequest>() {
				SeqDetailRequest info = null;
				@Override
				public SeqDetailRequest extractData(ResultSet rs) throws SQLException, DataAccessException {
					while (rs.next()) {
						info = new SeqDetailRequest();
						info.setClaimProcedureSeq(rs.getLong("CLAIM_PROCEDURE_SEQ"));
						info.setPrevAdjReasonCode(rs.getString("ADJUSTMENT_REASON_CODE_1"));
						info.setBdAdjAmt1(rs.getLong("ADJUSTMENT_AMOUNT_1"));
						info.setBdPaidAmt(rs.getLong("PAID_AMOUNT"));
					}
					return info;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return seqDetailRequest;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.ILineItemsRepositoryTemplate#getSequenceDetail(long, long)
	 */
	
	@Override
	public List<SeqDetailRequest> getCAGCDetail(long sequenceNumber, long claimIndex) {
		
		 String sql = "select cp.claim_procedure_seq, cpra.adjustment_group_cd" +
	    			" from claim_procedure cp, claim_proc_recon cpr, claim_proc_rec_adjust cpra" +
					" where cp.claim_index = ? and cp.claim_procedure_seq =  ?" +
					" and cp.claim_proc_id = cpr.claim_proc_id" +
					" and cpr.claim_proc_rec_id = cpra.claim_proc_rec_id(+)" + 
					" group by cp.claim_procedure_seq, cpra.adjustment_group_cd" +
					" order by claim_procedure_seq"; 
		
		List<SeqDetailRequest> seqDetailRequest = new ArrayList<>();
		try {
			seqDetailRequest = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, claimIndex);
					arg0.setLong(2, sequenceNumber);
				}
			}, new RowMapper<SeqDetailRequest>() {
				public SeqDetailRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
					SeqDetailRequest info = new SeqDetailRequest();
					info.setClaimProcedureSeq(rs.getLong("CLAIM_PROCEDURE_SEQ"));
					info.setAdjustmentGroupCd(rs.getString("ADJUSTMENT_GROUP_CD"));
					return info;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return seqDetailRequest;
	}

	@Override
	public List<SeqDetailRequest> getRARCDetail(long sequenceNumber, long claimIndex) {
		
		String sql = "select cp.claim_procedure_seq, cprr.remittance_remark_cd" +
    			" from claim_procedure cp, claim_proc_recon cpr, claim_proc_remit_remark cprr" +
				" where cp.claim_index = ? and cp.claim_procedure_seq =  ?" + 
				" and cp.claim_proc_id = cpr.claim_proc_id" +
				" and  cpr.claim_proc_rec_id = cprr.claim_proc_rec_id(+)" + 
				" group by cp.claim_procedure_seq, cprr.remittance_remark_cd" +
				" order by  claim_procedure_seq"; 

		List<SeqDetailRequest> seqDetailRequest = new ArrayList<>();
		try {
			seqDetailRequest = jdbcTemplate.query(sql, new PreparedStatementSetter() {
				@Override
				public void setValues(PreparedStatement arg0) throws SQLException {
					arg0.setLong(1, claimIndex);
					arg0.setLong(2, sequenceNumber);
				}
			}, new RowMapper<SeqDetailRequest>() {

				public SeqDetailRequest mapRow(ResultSet rs, int rowNum) throws SQLException {
					SeqDetailRequest info = new SeqDetailRequest();
					info.setClaimProcedureSeq(rs.getLong("CLAIM_PROCEDURE_SEQ"));
					info.setRemittanceRemarkCd(rs.getString("REMITTANCE_REMARK_CD"));
					return info;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		return seqDetailRequest;
	}
}
