package gov.va.med.fee.dao.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.stereotype.Repository;
import gov.va.med.domain.fee.PrivacyToPerson;
import gov.va.med.fee.dao.IPrivacyRestrictionRepositoryTemplate;
import gov.va.med.fee.model.request.PrivacyRestrictionRequest;

@Repository
public class IPrivecyRestrictionRepositoryTemplateImpl implements IPrivacyRestrictionRepositoryTemplate {

	private JdbcTemplate jdbcTemplate;
    private boolean deleteResponse = false ;
    private boolean insertResponse = false ;
	private static final Logger log = LogManager.getLogger(IPrivecyRestrictionRepositoryTemplateImpl.class);

	@Autowired
	public IPrivecyRestrictionRepositoryTemplateImpl(DataSource dataSource ){
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<PrivacyToPerson> getAllRestrictions() {
	
		List<PrivacyToPerson> allRestrictions = new ArrayList<>();
		
        String sql = " SELECT "
                + "     p.person_id, "
                + "     p.user_name, "
                + "     p.reason, "
                + "     p.created_by, "
                + "     p.date_created, "
                + "p.request_type_flag, "
                + "p.privacy_request_id "
                + " FROM privacy_to_person p "
                + " ORDER BY p.date_created DESC, p.person_id ASC, p.user_name ASC ";
      
           jdbcTemplate.update(sql, new PreparedStatementSetter() {
   			
	            public void setValues(PreparedStatement stmt) throws SQLException {
	            		            		
	                ResultSet	resultset = stmt.executeQuery();
	            	while(resultset.next()) {
	            		
	               PrivacyToPerson p = new PrivacyToPerson();
	               p.setPersonId(resultset.getString("person_id"));
	               p.setUserName(resultset.getString("user_name"));
	               p.setReason(resultset.getString("reason"));
	               p.setCreatedBy(resultset.getString("created_by"));
	               Date dateCreated = new Date();
	               try{
	            	   dateCreated = resultset.getDate("date_created");
	               } catch (Exception e) {
	                   log.debug("Error in extracting date data ", e);
	               }
	               p.setDateCreated(dateCreated);
	               p.setRequestTypeFlag(resultset.getString("request_type_flag"));	
	               p.setPrivacyRequestId(resultset.getBigDecimal("privacy_request_id").longValue());	            		
	               allRestrictions.add(p);
	            	}
	        
	            }
	            
	        });
           return allRestrictions;
           
	}	
//	@Override
//	public List<Integer> checkClaimsAssignedToUser(String ssn , String ntName) {
//	
//		
//		    List<Integer> result = new ArrayList<>();
//	
//	  String  sql = " SELECT "
//	     			+ "c.claim_index " 
//	     			+ "FROM claims c, "
//	     			+ "person_info p "
//		            + " WHERE c.claim_index=p.claim_index "
//		            + " AND UPPER(c.user_name)=UPPER(:ntname) AND p.person_id=:ssn"; 
//
//		 jdbcTemplate.update(sql, new PreparedStatementSetter() {
//			
//	            public void setValues(PreparedStatement stmt) throws SQLException {
//	            	
//	            	stmt.setString(1, ntName.trim().toUpperCase());
//	            	stmt.setString(2, ssn);	
//	               ResultSet	resultset = stmt.executeQuery();
//	            	while(resultset.next()) {
//	            	    result.add(resultset.getInt(0));
//	            	}
//	        
//	            }
//	            
//	        });
//		 
//		return result;
//
//	}

//	@Override
//	public boolean addRestriction(PrivacyRestrictionRequest request){
//		
//     String sql = " INSERT INTO "
//		 		+ "fpps_owner.privacy_to_person"
//		 		+ " (privacy_request_id"
//		 		+ ", user_name, person_id,"
//		 		+ " reason,"
//		 		+ " request_type_flag,"
//		 		+ " created_by, date_created) "
//	            + " VALUES(fpps_owner.mig.nextval, :ntname, :ssn, :reason, :type, :appuser, sysdate) ";
//
//		 jdbcTemplate.update(sql, new PreparedStatementSetter() {
//			    
//			public void setValues(PreparedStatement stmt) throws SQLException {
//
//				
//				stmt.setString(2, request.getNtName().trim().toUpperCase());
//				stmt.setString(3, request.getSsn());
//				stmt.setString(4, request.getReason());
//				stmt.setString(5, request.getType());
//				stmt.setString(6, request.getAppuser().getUserName());
//
//				System.err.println(stmt.toString());
//				stmt.execute();
//				stmt.execute("COMMIT");
//				stmt.executeUpdate();
//				insertResponse = true;
//			}
//
//		});
//
//		return insertResponse;
//
//	}
	
//	
//	@Override
//	public boolean addRestriction(PrivacyRestrictionRequest request){
//		System.err.println(request.toString());
//		
//		
//     String sql = " INSERT INTO "
//		 		+ "fpps_owner.privacy_to_person"
//		 		+ " (privacy_request_id"
//		 		+ ", user_name, person_id,"
//		 		+ " reason,"
//		 		+ " request_type_flag,"
//		 		+ " created_by, date_created) "
//	            + " VALUES(fpps_owner.mig.nextval, :ntname, :ssn, :reason, :type, :appuser, sysdate) ";
//
//     return jdbcTemplate.execute(sql,new PreparedStatementCallback<Boolean>(){  
//    	  
//    	 @Override  
//    	     public Boolean doInPreparedStatement(PreparedStatement stmt)  
//                throws SQLException, DataAccessException {  
//    	              System.err.println(stmt);
//    		    stmt.setString(2, request.getNtName().trim().toUpperCase());
//				stmt.setString(3, request.getSsn());
//				stmt.setString(4, request.getReason());
//				stmt.setString(5, request.getType());
//				stmt.setString(6, request.getAppuser().getUserName()); 
//    	              System.err.println(stmt);
//    	       return stmt.execute();  
//    	          
//    	    }  
//    	    });  
//    	}  

	
//	
//     @Override
//	public int checkExsistance(String ssn , String ntName){
//		
//		List<Integer> result = new ArrayList<>();
//		//check if privacy restriction is already in place for this user + ssn
//    String   sql = " SELECT COUNT(*) FROM fpps_owner.privacy_to_person p "
//                + " WHERE UPPER(p.user_name)=UPPER(:ntname) AND p.person_id=:ssn";
//
//		jdbcTemplate.update(sql, new PreparedStatementSetter() {
//			public void setValues(PreparedStatement stmt) throws SQLException {
//
//				stmt.setString(1, ntName.trim().toUpperCase());
//				stmt.setString(2, ssn);
//
//				ResultSet resultset = stmt.executeQuery();
//				while (resultset.next()) {
//					result.add(resultset.getInt(0));
//				}
//
//			}
//
//		});
//		return result.size();
//	}
//     
//    @Override
//	public boolean deleteRestrictions(int requestId) {
//
//		String sql = " DELETE FROM fpps_owner.privacy_to_person p " + " WHERE p.privacy_request_id=:id ";
//
//		jdbcTemplate.update(sql, new PreparedStatementSetter() {
//			public void setValues(PreparedStatement stmt) throws SQLException {
//
//				stmt.setInt(1, requestId);
//				stmt.execute();
//				deleteResponse = true;
//
//			}
//
//		});
//		return deleteResponse;
//	}

}
