package gov.va.med.fee.dao.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IClaimByStatusCodeRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IDisapproveClaimRepository;
import gov.va.med.fee.model.response.AdjustmentReasonResponse;

/**
 * @author vhaisbjahank
 * 
 * @Modifiedauthor: Vamsi Krishna Gangarapu
 * corrected populateAdjustmentReasons()
 * created getCount and updateWsFacStatus
 *
 */

@Repository
public class DisapproveClaimRepositoryImpl implements IDisapproveClaimRepository {

	private static final Logger logger = LogManager.getLogger(DisapproveClaimRepositoryImpl.class);

	private JdbcTemplate jdbcTemplate;
	
	@Autowired
	IClaimByStatusCodeRepository claimByStatusCodeRepository;
	
	@Autowired
	IClaimRepository claimRepository;
	
	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<AdjustmentReasonResponse> populateAdjustmentReasons() {
		logger.debug("populateAdjustmentReasons");
		List<AdjustmentReasonResponse> adjReasonList = new ArrayList<AdjustmentReasonResponse>();
		adjReasonList = jdbcTemplate.query("select * from ADJUSTMENT_REASON where ACTIVE_FLAG='Y'",
				new RowMapper<AdjustmentReasonResponse>() {

					@Override
					public AdjustmentReasonResponse mapRow(ResultSet rs, int rowNum) throws SQLException {

						AdjustmentReasonResponse adjustmentReasonResponse = new AdjustmentReasonResponse();
						adjustmentReasonResponse.setAdjustmentReasonCd(rs.getString("ADJUSTMENT_REASON_CD"));
						adjustmentReasonResponse.setDescription(rs.getString("DESCRIPTION"));

						return adjustmentReasonResponse;
					}
				});

		return adjReasonList;
	}

	@Override
	public BigDecimal getCount(Long claimId) {
		String sql = "select count(*) from claim_proc_recon cpr where cpr.claim_index = ?";
		BigDecimal count = jdbcTemplate.queryForObject(sql, new Object[] { claimId }, BigDecimal.class);
		return count;
	}

	@Override
	public Boolean updateWsFacStatusTable(Long claimId) {
		String rejectClaim = "REJECTED";
		String sql = "update ws_fac_status set claim_status_cd = ? where claim_index = ?";
		int[] types = {Types.VARCHAR, Types.BIGINT};
		int count = jdbcTemplate.update(sql, new Object[] { rejectClaim, claimId }, types);
		
		if(count > 0){
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public Boolean updateWsFacStatusTable(List<Long> claimIdsList, String claimStatus) {

		Long claimIds = (claimIdsList !=null ? new Long(Arrays.toString(claimIdsList.toArray()).replaceAll("[\\[\\]]", "")) : null);
		
		StringBuilder sqlquery = new StringBuilder();
		sqlquery.append("update ws_fac_status set claim_status_cd = "); 
		sqlquery.append(claimStatus);
		sqlquery.append(" where claim_index in (");
		sqlquery.append(claimIds);
		sqlquery.append(") ");
		int[] types = {Types.VARCHAR, Types.BIGINT};
		int count = jdbcTemplate.update(sqlquery.toString(), new Object[] { claimStatus, claimIdsList }, types);
		
		if(count > 0){
			return true;
		} else {
			return false;
		}
	}
	
}
