package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.ICodeLookupRepository;
import gov.va.med.fee.model.response.CodeLookupResponse;

/**
 * @author Muneshwar Baiah
 *
 */
@Repository
public class DiagnosisCodeLookupRepositoryImpl implements ICodeLookupRepository {

	public static final Logger logger = LogManager.getLogger(DiagnosisCodeLookupRepositoryImpl.class);
	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}


	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.ICodeLookupRepository#getCodes(java.lang.String, java.lang.String, java.lang.Integer, java.lang.String, java.lang.Integer)
	 */
	@Override
	public List<CodeLookupResponse> getCodes(String diagnosisCode, String codeType, Integer pageSize,
			String sortColumn, Boolean descending, Integer pageNumber) {
		logger.info("getCodes() : Retreiving the diagnosis codes from the database");
		List<CodeLookupResponse> codeLookupResponseList = new LinkedList<CodeLookupResponse>();

		try {
			StringBuilder sqlQuery = getdiagnosisCodesSqlQuery(diagnosisCode, codeType, pageSize, sortColumn, descending,
					pageNumber);
			logger.debug("getCodes() : Query used to get the diagnosis codes is : "+sqlQuery);
			codeLookupResponseList = jdbcTemplate.query(sqlQuery.toString(),
					new ResultSetExtractor<List<CodeLookupResponse>>() {

						@Override
						public List<CodeLookupResponse> extractData(ResultSet arg0)
								throws SQLException, DataAccessException {
							List<CodeLookupResponse> codeLookupResponseList = new ArrayList<CodeLookupResponse>();
							CodeLookupResponse diagnosisCodeResponse = null;

							while (arg0.next()) {
								diagnosisCodeResponse = new CodeLookupResponse();

								diagnosisCodeResponse.setCodeType(arg0.getString("CODE_TYPE"));
								diagnosisCodeResponse.setDrugExempt(arg0.getString("DRG_EXEMPT_FLAG"));
								diagnosisCodeResponse.setCode(arg0.getString("ICD_CODE"));
								diagnosisCodeResponse.setDescription(arg0.getString("ICD_DESC"));
								
								try {
									Date date = null;
									String formattedDate = null;
									if ( arg0.getString("EXPIRATION_DATE") != null ) {
										date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(arg0.getString("EXPIRATION_DATE"));
										formattedDate = new SimpleDateFormat("MM/dd/yyyy").format(date);
										diagnosisCodeResponse.setExpirationDate(formattedDate);
									}

									if ( arg0.getString("START_DATE") != null ) {
										date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(arg0.getString("START_DATE"));
										formattedDate = new SimpleDateFormat("MM/dd/yyyy").format(date);
										diagnosisCodeResponse.setStartDate(formattedDate);
									}
								} catch (ParseException e) {
									logger.error("Date formatting exception occured :"+e.getMessage());
								}


								codeLookupResponseList.add(diagnosisCodeResponse);
							}
							return codeLookupResponseList;
						}
					});
		} catch (Exception e) {
			logger.debug("getCodes() : Exception occured :"+e);
			e.printStackTrace();
		}

		logger.debug("getCodes() : codeLookupResponseList is "+codeLookupResponseList);
		return codeLookupResponseList;

	}

	private StringBuilder getdiagnosisCodesSqlQuery(String diagnosisCode, String codeType, Integer pageSize,
			String sortColumn, Boolean descending, Integer pageNumber) {

		StringBuilder sql = new StringBuilder();
		StringBuilder sqlQuery = new StringBuilder();
		
		StringBuilder sortByCriteria = new StringBuilder();
		sortByCriteria.append(" order by " + getIcdCodeTableColumnName(sortColumn));

		if ( descending == null || descending == false ) {
			sortByCriteria.append(" ASC "); 
		} else {
			sortByCriteria.append(" DESC");
		}
		
		sql.append("select diagnosisCode.*,  ROW_NUMBER() OVER ("+sortByCriteria+") r  from ICD_CODE diagnosisCode ");

		if (diagnosisCode != null && !(diagnosisCode.equalsIgnoreCase(null))) {
			sql.append(" WHERE ICD_CODE like "+"'"+diagnosisCode.toUpperCase()+'%'+"'");
		}

		if (diagnosisCode != null && codeType != null && !(diagnosisCode.equalsIgnoreCase(null)) && !(codeType.equalsIgnoreCase(null))) {

			sql.append(" AND CODE_TYPE like "+"'"+codeType.toUpperCase()+'%'+"'");
		} else {
			if(codeType != null && !(codeType.equalsIgnoreCase(null))) {
				sql.append(" WHERE CODE_TYPE like "+"'"+codeType.toUpperCase() + '%'+"'");
			}
		}
			
		if ((pageSize != null) && (pageNumber != null) && pageNumber >= 1) {

			int currentUpperLimit = pageSize * pageNumber;
			int currentLowerLimit = currentUpperLimit - pageSize;
			sqlQuery.append(
					"select * from (" + sql + ") where r >" + currentLowerLimit + " AND r<=" + currentUpperLimit);

		}
		return sqlQuery;

	}
	
	@Override
	public Long getCount(String diagnosisCode, String codeType, Integer pageSize,
			String sortColumn, Boolean descending, Integer pageNumber) {
		
		StringBuilder sql = new StringBuilder();
		sql.append("select count(*) from ICD_CODE diagnosisCode ");

		if (diagnosisCode != null && !(diagnosisCode.equalsIgnoreCase(null))) {
			sql.append(" WHERE ICD_CODE like "+"'"+diagnosisCode.toUpperCase()+'%'+"'");
		}

		if (diagnosisCode != null && codeType != null && !(diagnosisCode.equalsIgnoreCase(null)) && !(codeType.equalsIgnoreCase(null))) {

			sql.append(" AND CODE_TYPE like "+"'"+codeType.toUpperCase()+'%'+"'");
		} else {
			if(codeType != null && !(codeType.equalsIgnoreCase(null))) {
				sql.append(" WHERE CODE_TYPE like "+"'"+codeType.toUpperCase() + '%'+"'");
			}
		}

		sql.append(" order by " + getIcdCodeTableColumnName(sortColumn));

		if ( descending == null || descending == false ) {
			sql.append(" ASC "); 
		} else {
			sql.append(" DESC");
		}
		
		Long count = jdbcTemplate.queryForObject(sql.toString(), Long.class);
		return count;
	}
	
	
	/**
	 * @param param
	 * @return
	 */
	String getIcdCodeTableColumnName(String param) {
		if ( param != null ) {
		switch( param ) {
		case "codeType":
			return "CODE_TYPE";
		case "code":
			return "ICD_CODE";
		case "description":
			return "ICD_DESC";
		case "drugExempt":
			return "DRG_EXEMPT_FLAG";
		case "startDate":
			return "START_DATE";
		case "expirationDate":
			return "EXPIRATION_DATE";
		default:
			return "ICD_CD_ID";
		} } else {
			return "ICD_CD_ID";
		}
			
	}

}
