/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IClaimSearchRepositoryTemplate;
import gov.va.med.fee.model.request.ClaimSearchProcessingRequest;
import gov.va.med.fee.model.response.ClaimSearchResponse;
import gov.va.med.fee.util.ReplaceWildCardEntries;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public class ClaimSearchRepositoryTemplateImpl implements IClaimSearchRepositoryTemplate {

	private static HashMap<String, String> searchParametersToSet = new HashMap<String, String>();

	static int classCounter = 0;
	SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
	ReplaceWildCardEntries replaceWildCardEntries = null;

	private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	private JdbcTemplate jdbcTemplate;
	
	private static final Logger logger = LogManager.getLogger(ClaimSearchRepositoryTemplateImpl.class);

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fee.dao.IClaimSearchRepositoryTemplate#
	 * getClaimSearchResultsList(gov.va.med.fee.model.request.
	 * ClaimSearchProcessingRequest)
	 */
	@Override
	public List<ClaimSearchResponse> getClaimSearchResultsList(
			ClaimSearchProcessingRequest claimSearchProcessingRequest) {
		StringBuffer sql = sqlStringParameters(claimSearchProcessingRequest);

		List<ClaimSearchResponse> claimSearchResponseList = new ArrayList<ClaimSearchResponse>();

		try {
			claimSearchResponseList = namedParameterJdbcTemplate.query(sql.toString(), searchParametersToSet,
					new ResultSetExtractor<List<ClaimSearchResponse>>() {

						@Override
						public List<ClaimSearchResponse> extractData(ResultSet arg0)
								throws SQLException, DataAccessException {
							List<ClaimSearchResponse> claimSearchResponseList = new ArrayList<ClaimSearchResponse>();
							ClaimSearchResponse claimSearchResponse = null;
							while (arg0.next()) {
								claimSearchResponse = new ClaimSearchResponse();
								claimSearchResponse.setClaimId(arg0.getString("CLAIM_INDEX"));
								claimSearchResponse.setClaimType(arg0.getString("SERVICE_TYPE_CD"));
								claimSearchResponse.setClaimStatus(arg0.getString("CLAIM_STATUS_CD"));
								claimSearchResponse.setHeroFlag(arg0.getString("HERO_FLAG").charAt(0));
								claimSearchResponse.setVeteranName(arg0.getString("LAST_NAME")+", "+arg0.getString("FIRST_NAME")+" "+arg0.getString("MIDDLE_NAME"));
								claimSearchResponse.setSsn(arg0.getString("PERSON_ID"));
								claimSearchResponse.setPatientControlNumber(arg0.getString("PATIENT_CONTROL_NUMBER"));
								claimSearchResponse.setServiceDate(sdf.format(arg0.getDate("BEGIN_SERVICE_DATE")));
								claimSearchResponse.setProviderName(arg0.getString("PROVIDER_NAME"));
								claimSearchResponse.setProviderTin(arg0.getString("PROVIDER_TIN"));
								claimSearchResponse.setProviderNpi(arg0.getString("PROVIDER_NPI"));
								claimSearchResponse.setFacility(arg0.getString("VA_FACILITY_CD"));
								//removed assignedTo as per change request 596357
								//claimSearchResponse.setAssignedTo(arg0.getString("USER_NAME"));
								claimSearchResponseList.add(claimSearchResponse);
							}
							return claimSearchResponseList;
						}

					});

		} catch (Exception e) {
			e.printStackTrace();
		}
		classCounter = 0;
		searchParametersToSet.clear();
		return claimSearchResponseList;
	}

	private StringBuffer sqlStringParameters(ClaimSearchProcessingRequest claimSearchProcessingRequest) {

		StringBuffer sqlScript = new StringBuffer();
		String sql = null;
		replaceWildCardEntries = new ReplaceWildCardEntries();

		StringBuilder sortByCriteria = new StringBuilder();
		String column = getClaimSearchTableColumnName(claimSearchProcessingRequest.getSortColumn());
		if (column == "CLAIM_INDEX") {
			claimSearchProcessingRequest.setSortColumn("claimId");
		}

		sortByCriteria.append(" order by " + column);

		if (claimSearchProcessingRequest.getDescending() == null
				|| claimSearchProcessingRequest.getDescending() == false) {
			sortByCriteria.append(" ASC ");
		} else {
			sortByCriteria.append(" DESC");
		}

		sql = "SELECT c.claim_index, c.service_type_cd, c.hero_flag, c.begin_service_date, pi.last_name, pi.first_name, pi.middle_name, pi.name_suffix, pi.person_id, fpps_owner.get_provider_search (c.claim_index, 1) AS provider_name, fpps_owner.get_provider_search (c.claim_index, 2) AS provider_npi, fpps_owner.get_provider_search (c.claim_index, 3) AS provider_tin, c.user_name, c.claim_status_cd, c.patient_control_number, c.va_facility_cd, CASE WHEN ca.edi_claim_key IS NOT NULL THEN 'Y' ELSE 'N' END AS claimAttachmentsFlag, ROW_NUMBER() OVER("
				+ sortByCriteria
				+ ") r FROM fpps_owner.claims c, fpps_owner.person_info pi, fpps_owner.claim_attachments ca WHERE c.claim_index = pi.claim_index(+) ";

		sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimType(), "AND c.service_type_cd", "");
		sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimStatus(), "AND c.claim_status_cd", "");
		sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimStatus(), "AND c.claim_status_cd", "");
		sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimId(), "AND c.claim_index", "");
		/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getPatientControlNumber(),
				"AND c.claim_index IN (SELECT ci.claim_index FROM claims ci WHERE ci.patient_control_number", ")");
		sql += appendSqlStringParameters(claimSearchProcessingRequest.getSsn(),
				"AND c.claim_index IN (SELECT pii.claim_index FROM fpps_owner.person_info pii WHERE pii.person_id",
				")");
		sql += appendSqlStringParameters(claimSearchProcessingRequest.getLastName(),
				"AND c.claim_index IN (SELECT piii.claim_index FROM fpps_owner.person_info piii WHERE piii.last_name",
				")");

		if (((claimSearchProcessingRequest.getProviderName() != null)
				&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("")
				&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("%")
				&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("_"))
				|| ((claimSearchProcessingRequest.getProviderNpi() != null)
						&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("")
						&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("%")
						&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("_"))
				|| ((claimSearchProcessingRequest.getProviderName() != null)
						&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("")
						&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("%")
						&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("_"))) {
			sql += " and exists ( " + " select ws.claim_index " + " from fpps_owner.provider_info ws "
					+ " where ws.claim_index = c.claim_index ";

			sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderName(), " AND ws.last_name ", "");
			sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderTin(), " AND ws.provider_tin ",
					"");
			sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderNpi(), " AND ws.provider_npi ",
					"");

			sql += " ) ";

		}

		if ((claimSearchProcessingRequest.getCheck_Eft_Trn() != null)
				&& (!claimSearchProcessingRequest.getCheck_Eft_Trn().trim().isEmpty())) {
			sql += appendSqlStringParameters(claimSearchProcessingRequest.getCheck_Eft_Trn(),
					"and c.claim_index in (select claim_index from claim_payment cpay where payment_tracking_number ",
					")");
		}*/
		
		if(claimSearchProcessingRequest.getPatientControlNumber()!=null && !claimSearchProcessingRequest.getPatientControlNumber().trim().equalsIgnoreCase("")) {
			sql += "AND c.claim_index IN (SELECT ci.claim_index FROM claims ci WHERE regexp_like(ci.patient_control_number, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getPatientControlNumber())+ "', 'i'))";
		}
		if(claimSearchProcessingRequest.getSsn()!=null && !claimSearchProcessingRequest.getSsn().trim().equalsIgnoreCase("")) {
			sql += "AND c.claim_index IN (SELECT pii.claim_index FROM fpps_owner.person_info pii WHERE regexp_like(pii.person_id, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getSsn())+ "', 'i'))";
		}
		
		if(claimSearchProcessingRequest.getLastName()!=null && !claimSearchProcessingRequest.getLastName().trim().equalsIgnoreCase("")) {
			sql += "AND c.claim_index IN (SELECT piii.claim_index FROM fpps_owner.person_info piii WHERE regexp_like(piii.last_name, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getLastName()) + "', 'i'))";
		}

		if (((claimSearchProcessingRequest.getProviderName() != null)
				&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("")
				&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("%")
				&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("_"))
				|| ((claimSearchProcessingRequest.getProviderNpi() != null)
						&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("")
						&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("%")
						&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("_"))
				|| ((claimSearchProcessingRequest.getProviderName() != null)
						&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("")
						&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("%")
						&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("_"))) {
			sql += " and exists ( " + " select ws.claim_index " + " from fpps_owner.provider_info ws "
					+ " where ws.claim_index = c.claim_index ";

			/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderName(), " AND ws.last_name ",
					"");*/
			
			if(claimSearchProcessingRequest.getProviderName()!=null && !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("")) {
				sql += "AND regexp_like(ws.last_name, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getProviderName())+ "', 'i')";
			}
			
			if(claimSearchProcessingRequest.getProviderTin()!=null && !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("")) {
				sql += "AND regexp_like(ws.provider_tin, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getProviderTin())+ "', 'i')";
			}
			
			if(claimSearchProcessingRequest.getProviderNpi()!=null && !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("")) {
				sql += "AND regexp_like(ws.provider_npi, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getProviderNpi())+ "', 'i')";
			}
			
			/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderTin(), " AND ws.provider_tin ",
					"");*/
			
			/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderNpi(), " AND ws.provider_npi ",
					"");*/

			sql += " ) ";

		}

		if ((claimSearchProcessingRequest.getCheck_Eft_Trn() != null)
				&& (!claimSearchProcessingRequest.getCheck_Eft_Trn().trim().isEmpty())) {
			/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getCheck_Eft_Trn(),
					"and c.claim_index in (select claim_index from claim_payment cpay where payment_tracking_number ",
					")");*/
			
			sql += "and c.claim_index in (select claim_index from claim_payment cpay where regexp_like(payment_tracking_number , " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getCheck_Eft_Trn())+ "', 'i'))";
		}
		
		/*
		 * Append the user determined heroFlag boolean to the SQL statement
		 */
		if (claimSearchProcessingRequest.getHero()) {
			sql += " AND c.hero_flag = 'Y' ";
		}

		/* Append the lower claim date range to the SQL statement */
		if ((claimSearchProcessingRequest.getBeginServiceDate() != null) && (!claimSearchProcessingRequest.getBeginServiceDate().equalsIgnoreCase("")) && (claimSearchProcessingRequest.getBeginServiceDate() != "")) {
			DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
			SimpleDateFormat newFormat = new SimpleDateFormat("dd-MMM-yyyy");
			try {
				Date beginServiceDate = formatter.parse(claimSearchProcessingRequest.getBeginServiceDate());
				String beginDate = newFormat.format(beginServiceDate);
				sql += (" AND c.begin_service_date >=  '" + beginDate + "'");

			} catch (ParseException e) {
				e.printStackTrace();
			}
		}

		/* Append the upper claim date range to the SQL statement */
		if ((claimSearchProcessingRequest.getEndServiceDate() != null) && (!claimSearchProcessingRequest.getEndServiceDate().trim().equalsIgnoreCase("")) && (claimSearchProcessingRequest.getEndServiceDate() != "")) {
			DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
			SimpleDateFormat newFormat = new SimpleDateFormat("dd-MMM-yyyy");
			try {
				Date endServiceDate = formatter.parse(claimSearchProcessingRequest.getEndServiceDate());
				String endDate = newFormat.format(endServiceDate);
				sql += (" AND c.begin_service_date <= '" + endDate + "'");
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}

		String groupBy = " GROUP BY c.claim_index,  c.service_type_cd, c.hero_flag, c.begin_service_date, "
				+ "pi.last_name, pi.first_name, pi.middle_name, pi.name_suffix, pi.person_id, "
				+ "c.user_name, c.claim_status_cd, c.patient_control_number, c.va_facility_cd, "
				+ "CASE WHEN ca.edi_claim_key IS NOT NULL THEN 'Y' ELSE 'N' END ";

		sql += groupBy;

		if ((claimSearchProcessingRequest.getPageSize() != null)
				&& (claimSearchProcessingRequest.getPageNumber() != null)
				&& claimSearchProcessingRequest.getPageNumber() >= 1) {

			int currentUpperLimit = claimSearchProcessingRequest.getPageSize()
					* claimSearchProcessingRequest.getPageNumber();
			int currentLowerLimit = currentUpperLimit - claimSearchProcessingRequest.getPageSize();

			sqlScript.append(
					"select * from (" + sql + ") where r >" + currentLowerLimit + " AND r<=" + currentUpperLimit);
			// sql += (" AND ROWNUM >" + currentLowerLimit + " AND ROWNUM <= " +
			// currentUpperLimit + groupBy);

			// sql += sortByCriteria;

		}
		return sqlScript;
	}

	public Long getCountResults(ClaimSearchProcessingRequest claimSearchProcessingRequest) {

		String sql = null;
		replaceWildCardEntries = new ReplaceWildCardEntries();

		if ((claimSearchProcessingRequest.getPageSize() != null)
				&& (claimSearchProcessingRequest.getPageNumber() != null)
				&& claimSearchProcessingRequest.getPageNumber() >= 1) {

			sql = "SELECT count(*) FROM fpps_owner.claims c, fpps_owner.person_info pi, fpps_owner.claim_attachments ca WHERE c.claim_index = pi.claim_index(+) ";

			sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimType(), "AND c.service_type_cd", "");
			sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimStatus(), "AND c.claim_status_cd",
					"");
			sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimStatus(), "AND c.claim_status_cd",
					"");
			sql += appendSqlStringParameters(claimSearchProcessingRequest.getClaimId(), "AND c.claim_index", "");
			/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getPatientControlNumber(),
					"AND c.claim_index IN (SELECT ci.claim_index FROM claims ci WHERE ci.patient_control_number", ")");*/
			/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getSsn(),
					"AND c.claim_index IN (SELECT pii.claim_index FROM fpps_owner.person_info pii WHERE pii.person_id",
					")");*/
			/*sql += appendSqlStringParameters1(claimSearchProcessingRequest.getLastName(),
					"AND c.claim_index IN (SELECT piii.claim_index FROM fpps_owner.person_info piii WHERE regexp_like(piii.last_name",
					"', 'i')");*/
			
			
			if(claimSearchProcessingRequest.getPatientControlNumber()!=null && !claimSearchProcessingRequest.getPatientControlNumber().trim().equalsIgnoreCase("")) {
				sql += "AND c.claim_index IN (SELECT ci.claim_index FROM claims ci WHERE regexp_like(ci.patient_control_number, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getPatientControlNumber())+ "', 'i'))";
			}
			if(claimSearchProcessingRequest.getSsn()!=null && !claimSearchProcessingRequest.getSsn().trim().equalsIgnoreCase("")) {
				sql += "AND c.claim_index IN (SELECT pii.claim_index FROM fpps_owner.person_info pii WHERE regexp_like(pii.person_id, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getSsn())+ "', 'i'))";
			}
			
			if(claimSearchProcessingRequest.getLastName()!=null && !claimSearchProcessingRequest.getLastName().trim().equalsIgnoreCase("")) {
				sql += "AND c.claim_index IN (SELECT piii.claim_index FROM fpps_owner.person_info piii WHERE regexp_like(piii.last_name, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getLastName()) + "', 'i'))";
			}

			if (((claimSearchProcessingRequest.getProviderName() != null)
					&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("")
					&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("%")
					&& !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("_"))
					|| ((claimSearchProcessingRequest.getProviderNpi() != null)
							&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("")
							&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("%")
							&& !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("_"))
					|| ((claimSearchProcessingRequest.getProviderName() != null)
							&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("")
							&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("%")
							&& !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("_"))) {
				sql += " and exists ( " + " select ws.claim_index " + " from fpps_owner.provider_info ws "
						+ " where ws.claim_index = c.claim_index ";

				/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderName(), " AND ws.last_name ",
						"");*/
				
				if(claimSearchProcessingRequest.getProviderName()!=null && !claimSearchProcessingRequest.getProviderName().trim().equalsIgnoreCase("")) {
					sql += "AND regexp_like(ws.last_name, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getProviderName())+ "', 'i')";
				}
				
				if(claimSearchProcessingRequest.getProviderTin()!=null && !claimSearchProcessingRequest.getProviderTin().trim().equalsIgnoreCase("")) {
					sql += "AND regexp_like(ws.provider_tin, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getProviderTin())+ "', 'i')";
				}
				
				if(claimSearchProcessingRequest.getProviderNpi()!=null && !claimSearchProcessingRequest.getProviderNpi().trim().equalsIgnoreCase("")) {
					sql += "AND regexp_like(ws.provider_npi, " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getProviderNpi())+ "', 'i')";
				}
				
				/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderTin(), " AND ws.provider_tin ",
						"");*/
				
				/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getProviderNpi(), " AND ws.provider_npi ",
						"");*/

				sql += " ) ";

			}

			if ((claimSearchProcessingRequest.getCheck_Eft_Trn() != null)
					&& (!claimSearchProcessingRequest.getCheck_Eft_Trn().trim().isEmpty())) {
				/*sql += appendSqlStringParameters(claimSearchProcessingRequest.getCheck_Eft_Trn(),
						"and c.claim_index in (select claim_index from claim_payment cpay where payment_tracking_number ",
						")");*/
				
				sql += "and c.claim_index in (select claim_index from claim_payment cpay where regexp_like(payment_tracking_number , " + "'" + replaceWildCardEntries.getReplacedCharactersforClaims(claimSearchProcessingRequest.getCheck_Eft_Trn())+ "', 'i'))";
			}
			/*
			 * Append the user determined heroFlag boolean to the SQL statement
			 */
			if (claimSearchProcessingRequest.getHero()) {
				sql += " AND c.hero_flag = 'Y' ";
			}

			/* Append the lower claim date range to the SQL statement */
			if ((claimSearchProcessingRequest.getBeginServiceDate() != null) && (!claimSearchProcessingRequest.getBeginServiceDate().equals("")) && (claimSearchProcessingRequest.getBeginServiceDate() != "")) {
				DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
				SimpleDateFormat newFormat = new SimpleDateFormat("dd-MMM-yyyy");
				try {
					Date beginServiceDate = formatter.parse(claimSearchProcessingRequest.getBeginServiceDate());
					String beginDate = newFormat.format(beginServiceDate);
					sql += (" AND c.begin_service_date >=  '" + beginDate + "'");

				} catch (ParseException e) {
					e.printStackTrace();
				}
			}

			/* Append the upper claim date range to the SQL statement */
			if ((claimSearchProcessingRequest.getEndServiceDate() != null) && (!claimSearchProcessingRequest.getEndServiceDate().equals("")) && (claimSearchProcessingRequest.getEndServiceDate() != "")) {
				DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
				SimpleDateFormat newFormat = new SimpleDateFormat("dd-MMM-yyyy");
				try {
					Date endServiceDate = formatter.parse(claimSearchProcessingRequest.getEndServiceDate());
					String endDate = newFormat.format(endServiceDate);
					sql += (" AND c.begin_service_date <= '" + endDate + "'");
				} catch (ParseException e) {
					e.printStackTrace();
				}
			}

		}
		Long count = namedParameterJdbcTemplate.queryForObject(sql, searchParametersToSet, Long.class);
		return count;
	}

	private static String appendSqlStringParameters(String searchParam, String prefix, String suffix) {
		String ret = "";
		String param = "p" + classCounter++;

		if ((searchParam != null) && !searchParam.trim().equals("") && !searchParam.trim().equals("%")
				&& !searchParam.trim().equals("_")) {
			if ((searchParam.trim().indexOf("%") >= 0) || (searchParam.trim().indexOf("_") >= 0)) {
				ret += (" " + prefix + " LIKE :" + param + " " + suffix);
				param = param.replace("\\s", "");
				searchParametersToSet.put(param, searchParam.toUpperCase());
			} else {
				ret += (" " + prefix + " = :" + param + " " + suffix);
				param = param.replace("\\s", "");
				searchParametersToSet.put(param, searchParam.toUpperCase());
			}
		}

		return ret;

	}

	/**
	 * @param param
	 * @return
	 */
	String getClaimSearchTableColumnName(String param) {
		if (param != null) {
			switch (param) {
			case "claimType":
				return "c.SERVICE_TYPE_CD";
			case "claimStatus":
				return "c.CLAIM_STATUS_CD";
			case "heroFlag":
				return "c.HERO_FLAG";
			case "veteranName":
				return "pi.LAST_NAME";
			case "ssn":
				return "pi.PERSON_ID";
			case "patientControlNumber":
				return "c.PATIENT_CONTROL_NUMBER";
			case "serviceDate":
				return "c.BEGIN_SERVICE_DATE";
			case "providerName":
				return "fpps_owner.get_provider_search (c.claim_index, 1)";
			case "providerTin":
				return "fpps_owner.get_provider_search (c.claim_index, 3)";
			case "providerNpi":
				return "fpps_owner.get_provider_search (c.claim_index, 2)";
			case "facility":
				return "c.VA_FACILITY_CD";
			case "assignedTo":
				return "c.USER_NAME";
			default:
				return "c.CLAIM_INDEX";
			}
		} else {
			return "c.CLAIM_INDEX";
		}
	}

	@Override
	public ClaimSearchResponse getOneClaimSearchResult(String claimId) {
		ClaimSearchResponse claimSearchResponse = new ClaimSearchResponse();
		try {
			String sql = "SELECT c.claim_index, c.service_type_cd, c.hero_flag, c.begin_service_date, pi.last_name, pi.first_name, pi.middle_name, pi.name_suffix, pi.person_id, fpps_owner.get_provider_search (c.claim_index, 1) AS provider_name, fpps_owner.get_provider_search (c.claim_index, 2) AS provider_npi, fpps_owner.get_provider_search (c.claim_index, 3) AS provider_tin, c.user_name, c.claim_status_cd, c.patient_control_number, c.va_facility_cd, CASE WHEN ca.edi_claim_key IS NOT NULL THEN 'Y' ELSE 'N' END AS claimAttachmentsFlag FROM fpps_owner.claims c, fpps_owner.person_info pi, fpps_owner.claim_attachments ca WHERE c.claim_index = pi.claim_index(+) AND c.claim_index = ?";
			claimSearchResponse = jdbcTemplate.query(sql.toString(), new Object[] { claimId },
					new ResultSetExtractor<ClaimSearchResponse>() {

						@Override
						public ClaimSearchResponse extractData(ResultSet arg0)
								throws SQLException, DataAccessException {
							ClaimSearchResponse claimSearchResponse = null;
							while (arg0.next()) {
								claimSearchResponse = new ClaimSearchResponse();
								claimSearchResponse.setClaimId(arg0.getString("CLAIM_INDEX"));
								claimSearchResponse.setClaimType(arg0.getString("SERVICE_TYPE_CD"));
								claimSearchResponse.setClaimStatus(arg0.getString("CLAIM_STATUS_CD"));
								claimSearchResponse.setHeroFlag(arg0.getString("HERO_FLAG").charAt(0));
								claimSearchResponse.setVeteranName(arg0.getString("LAST_NAME"));
								claimSearchResponse.setSsn(arg0.getString("PERSON_ID"));
								claimSearchResponse.setPatientControlNumber(arg0.getString("PATIENT_CONTROL_NUMBER"));
								claimSearchResponse.setServiceDate(sdf.format(arg0.getDate("BEGIN_SERVICE_DATE")));
								claimSearchResponse.setProviderName(arg0.getString("PROVIDER_NAME"));
								claimSearchResponse.setProviderTin(arg0.getString("PROVIDER_TIN"));
								claimSearchResponse.setProviderNpi(arg0.getString("PROVIDER_NPI"));
								claimSearchResponse.setFacility(arg0.getString("VA_FACILITY_CD"));
								//removed assignedTo as per change request 596357
								//claimSearchResponse.setAssignedTo(arg0.getString("USER_NAME"));
							}
							return claimSearchResponse;
						}

					});

		} catch (Exception e) {
			e.printStackTrace();
		}
		classCounter = 0;
		searchParametersToSet.clear();
		return claimSearchResponse;
	}
}