/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.ICarcDetailRepositoryTemplate;
import gov.va.med.fee.model.request.CarcInfoRequest;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public class CarInfoItemsRepositoryTemplate implements ICarcDetailRepositoryTemplate {

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.ICarcDetailRepositoryTemplate#CarItemsInfo(java.lang.Long, java.math.BigDecimal)
	 */
	@Override
	public CarcInfoRequest CarItemsInfo(Long claimIndex, BigDecimal sequenceNumber) {

		String sql = "select cp.claim_procedure_seq, adjustment_reason_cd as adjustment_reason_code_1, adjustment_amount as adjustment_amount_1, cpr.paid_amount from claim_procedure cp, claim_proc_recon cpr left outer join claim_proc_rec_adjust cadj on cpr.claim_proc_rec_id = CADJ.CLAIM_PROC_REC_ID where cp.claim_index = :claimIndex and cp.claim_procedure_seq = :sequenceNumber and cp.claim_proc_id = cpr.claim_proc_id order by claim_procedure_seq";
		CarcInfoRequest carItemsInfo = jdbcTemplate.query(sql, new Object[] { claimIndex, sequenceNumber },
				new ResultSetExtractor<CarcInfoRequest>() {

					CarcInfoRequest carItemsInfo = null;

					@Override
					public CarcInfoRequest extractData(ResultSet rs) throws SQLException, DataAccessException {
						while (rs.next()) {
							carItemsInfo = new CarcInfoRequest();
							carItemsInfo.setDprocSeq(rs.getBigDecimal("CLAIM_PROCEDURE_SEQ"));
							carItemsInfo.setPrevAdjReasonCode(rs.getString("ADJUSTMENT_REASON_CODE_1"));
							carItemsInfo.setBdAdjAmt1(rs.getBigDecimal("ADJUSTMENT_AMOUNT_1"));
							carItemsInfo.setBdPaidAmt(rs.getBigDecimal("PAID_AMOUNT"));

						}
						return carItemsInfo;
					}

				});
		return carItemsInfo;

	}

}
