/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.domain.fee.ProviderType;
import gov.va.med.fee.dao.IBillingRepositoryTemplate;

/**
 * @author Vamsi Krishna Gangarapu 
 * 		   JDBC Template for Billing Provider
 *         Information This is the repository to get the Billing Provider
 *         information from Provider_Type table with Claim Id and Billing
 *         Provider Type. Provider Type for Billing Provider Information is of
 *         two types. 1. BILLING PROVIDER - for all the claims filed after
 *         8/2007 2. REMITADDR - for all the claims filed before 8/2007
 *
 */
@Repository
public class BillingRepositoryTemplateImpl implements IBillingRepositoryTemplate {

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fee.dao.IBillingTemplate#findOneByProvider(java.lang.Long,
	 * java.lang.String, java.lang.String)
	 */
	@Override
	public ProviderInfo findOneByProvider(Long claimIndex, String providerType_new, String providerType_old) {

		String sql = "SELECT p.last_name, p.address_line1, p.address_line2, p.city, p.state, p.zip_code, p.phone_number, p.provider_tin, p.contact_name, p.fax_number, p.e_mail, p.provider_type_cd, p.provider_npi, (select max(pr.provider_type_cd) from provider_info pr where (pr.provider_type_cd= ? OR pr.provider_type_cd= ?) and pr.claim_index= ?) as providerType FROM provider_info p  WHERE claim_index= ? and (p.provider_type_cd= ? OR p.provider_type_cd= ?)";
		ProviderInfo providerInfo = jdbcTemplate.query(sql, new Object[] { providerType_new, providerType_old,
				claimIndex, claimIndex, providerType_new, providerType_old }, new ResultSetExtractor<ProviderInfo>() {

					ProviderInfo providerInfo = null;
					ProviderType providerType = null;
					Claim claim = null;

					@Override
					public ProviderInfo extractData(ResultSet rs) throws SQLException, DataAccessException {
						while (rs.next()) {
							providerInfo = new ProviderInfo();
							providerType = new ProviderType();
							claim = new Claim();
							providerType.setProviderTypeCd(rs.getString("PROVIDER_TYPE_CD"));
							claim.setClaimIndex(claimIndex);

							providerInfo.setProviderNpi(rs.getString("PROVIDER_NPI"));
							providerInfo.setProviderTin(rs.getString("PROVIDER_TIN"));
							providerInfo.setCity(rs.getString("CITY"));
							providerInfo.setState(rs.getString("STATE"));
							providerInfo.setFaxNumber(rs.getString("FAX_NUMBER"));
							providerInfo.setZipCode(rs.getString("ZIP_CODE"));
							providerInfo.setPhoneNumber(rs.getString("PHONE_NUMBER"));
							providerInfo.setContactName(rs.getString("CONTACT_NAME"));
							providerInfo.setEMail(rs.getString("E_MAIL"));
							providerInfo.setAddressLine2(rs.getString("ADDRESS_LINE2"));
							providerInfo.setAddressLine1(rs.getString("ADDRESS_LINE1"));
							providerInfo.setLastName(rs.getString("last_name"));
							providerInfo.setProviderType(providerType);
							providerInfo.setClaim(claim);
						}
						return providerInfo;
					}

				});
		return providerInfo;
	}

}
