/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AdjustmentReason;
import gov.va.med.domain.fee.RemittanceRemark;
import gov.va.med.fee.dao.IAdjustmentsRepository;
import gov.va.med.fee.model.response.AdjustmentReasonResponse;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public class AdjustmentsRepositoryTemplateImpl implements IAdjustmentsRepository {

	private static final Logger logger = LogManager.getLogger(DisapproveClaimRepositoryImpl.class);

	private JdbcTemplate jdbcTemplate;
	
	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}
	
	@Override
	public List<AdjustmentReasonResponse> populateAdjustmentReasons() {
		logger.debug("populateAdjustmentReasons");
		List<AdjustmentReasonResponse> adjReasonList = new ArrayList<AdjustmentReasonResponse>();
		adjReasonList = jdbcTemplate.query("select adj.* from ADJUSTMENT_REASON adj where adj.ACTIVE_FLAG='Y'",
				new RowMapper<AdjustmentReasonResponse>() {

					@Override
					public AdjustmentReasonResponse mapRow(ResultSet rs, int rowNum) throws SQLException {

						AdjustmentReasonResponse adjustmentReasonResponse = new AdjustmentReasonResponse();
						adjustmentReasonResponse.setAdjustmentReasonCd(rs.getString("ADJUSTMENT_REASON_CD"));
						adjustmentReasonResponse.setDescription(rs.getString("DESCRIPTION"));

						return adjustmentReasonResponse;
					}
				});

		return adjReasonList;
	}

	@Override
	public List<AdjustmentReasonResponse> populateAdjustmentGroups() {
		logger.debug("populateAdjustmentReasons");
		List<AdjustmentReasonResponse> adjGroupList = new ArrayList<AdjustmentReasonResponse>();
		adjGroupList = jdbcTemplate.query("select adj.* from ADJUSTMENT_GROUP adj",
				new RowMapper<AdjustmentReasonResponse>() {

					@Override
					public AdjustmentReasonResponse mapRow(ResultSet rs, int rowNum) throws SQLException {

						AdjustmentReasonResponse adjustmentReasonResponse = new AdjustmentReasonResponse();
						adjustmentReasonResponse.setAdjustmentReasonCd(rs.getString("ADJUSTMENT_GROUP_CD"));
						adjustmentReasonResponse.setDescription(rs.getString("DESCRIPTION"));

						return adjustmentReasonResponse;
					}
				});

		return adjGroupList;
	}
	
	@Override
	public List<AdjustmentReason> findAdjustmentReasonByGroupCode(String groupCode){
		logger.debug("findAdjustmentReasonByGroupCode");
		List<AdjustmentReason> adjReasonList = new ArrayList<AdjustmentReason>();
		StringBuilder sb = new StringBuilder();
		sb.append("SELECT DISTINCT CRC.CARC_ID AS CODE, AR.DESCRIPTION, CRC.CAGC AS CAGC, CRC.BUSINESS_RULE AS BUSINESSRULE ");
		sb.append("FROM FPPS_OWNER.ADJUSTMENT_REASON AR JOIN FPPS_OWNER.CARC_RARC_CROSSWALK CRC ");
		sb.append("ON AR.ADJUSTMENT_REASON_CD = CRC.CARC_ID ");
		sb.append("WHERE CRC.CAGC  LIKE '%" + groupCode + "%' " );
		sb.append("AND AR.ACTIVE_FLAG = 'Y' ");
		sb.append("GROUP BY CRC.CARC_ID, AR.DESCRIPTION, CRC.CAGC, CRC.BUSINESS_RULE  ");
		sb.append("UNION  ");
		sb.append("SELECT AR2.ADJUSTMENT_REASON_CD AS CODE, AR2.DESCRIPTION, TO_CHAR(NULL) AS CAGC, 0 AS BUSINESSRULE ");
		sb.append("FROM FPPS_OWNER.ADJUSTMENT_REASON AR2 ");
		sb.append("WHERE AR2.ADJUSTMENT_REASON_CD NOT IN ");
		sb.append("(SELECT CRC2.CARC_ID FROM FPPS_OWNER.CARC_RARC_CROSSWALK CRC2 GROUP BY CRC2.CARC_ID)	");
		sb.append("AND AR2.ACTIVE_FLAG = 'Y' ");
		sb.append("GROUP BY AR2.ADJUSTMENT_REASON_CD, AR2.DESCRIPTION ");
		sb.append("ORDER BY CODE ASC ");
		
		adjReasonList = jdbcTemplate.query(sb.toString(),
				new RowMapper<AdjustmentReason>() {

					@Override
					public AdjustmentReason mapRow(ResultSet rs, int rowNum) throws SQLException {

						AdjustmentReason adjustmentReason = new AdjustmentReason();
						adjustmentReason.setAdjustmentReasonCd(rs.getString("CODE"));
						adjustmentReason.setDescription(rs.getString("DESCRIPTION"));

						return adjustmentReason;
					}
				});

		return adjReasonList;		
	}

	@Override
	public List<RemittanceRemark> findRemittanceRemarksByReasonCode(String reasonCode){
		logger.debug("findRemittanceRemarks");
		List<RemittanceRemark> remittanceRemarkList = new ArrayList<RemittanceRemark>();
		StringBuilder sb = new StringBuilder();
		sb.append("SELECT DISTINCT RR.REMITTANCE_REMARK_CD CODE, RR.DESCRIPTION, RR.FEE_USAGE_FLAG, ");
		sb.append("RR.CREATED_BY, RR.START_DATE, RR.END_DATE, RR.DATE_CREATED ");
		sb.append("FROM FPPS_OWNER.REMITTANCE_REMARK RR ");
		sb.append("JOIN FPPS_OWNER.CARC_RARC_CROSSWALK CWS ON RR.REMITTANCE_REMARK_CD = CWS.RARC_ID ");
		sb.append("JOIN FPPS_OWNER.ADJUSTMENT_REASON ARI ON CWS.CARC_ID=ARI.ADJUSTMENT_REASON_CD ");
		sb.append("WHERE RR.ACTIVE_FLAG = 'Y' AND CWS.CARC_ID = '");
		sb.append(reasonCode);
		sb.append("' ");
		sb.append("ORDER BY RR.REMITTANCE_REMARK_CD, RR.DESCRIPTION");
		
		remittanceRemarkList = jdbcTemplate.query(sb.toString(),
				new RowMapper<RemittanceRemark>() {

					@Override
					public RemittanceRemark mapRow(ResultSet rs, int rowNum) throws SQLException {

						RemittanceRemark remittanceRemark = new RemittanceRemark();
						remittanceRemark.setRemittanceRemarkCd(rs.getString("CODE"));
						remittanceRemark.setDescription(rs.getString("DESCRIPTION"));
						/*remittanceRemark.setFeeUsageFlag(rs.getString("FEE_USAGE_FLAG").charAt(0));
						remittanceRemark.setCreatedBy(rs.getString("CREATED_BY"));
						remittanceRemark.setDateCreated(rs.getDate("DATE_CREATED"));*/
						
						return remittanceRemark;
					}
				});

		// IF THERE ARE NO ASSOCIATED REMARKS, RETURN ALL RECORDS
		if(remittanceRemarkList == null || remittanceRemarkList.isEmpty()) {
			remittanceRemarkList = findAllRemittanceRemarks();
		}
		return remittanceRemarkList;				
	}
	
	
	private List<RemittanceRemark> findAllRemittanceRemarks(){
		logger.debug("findAllRemittanceRemarks");
		List<RemittanceRemark> remittanceRemarkList = new ArrayList<RemittanceRemark>();
		StringBuilder sb = new StringBuilder();
		sb.append("SELECT DISTINCT RR.REMITTANCE_REMARK_CD CODE, RR.DESCRIPTION, RR.START_DATE, RR.END_DATE ");
/*		sb.append("FROM FPPS_OWNER.REMITTANCE_REMARK RR, FPPS_OWNER.CARC_RARC_CROSSWALK CWS  JOIN ");
		sb.append("FPPS_OWNER.REMITTANCE_REMARK RR2 ON  CWS.RARC_ID=RR2.REMITTANCE_REMARK_CD  JOIN ");
		sb.append("FPPS_OWNER.ADJUSTMENT_REASON ARI ON  CWS.CARC_ID=ARI.ADJUSTMENT_REASON_CD ");*/
		sb.append("FROM FPPS_OWNER.REMITTANCE_REMARK RR ");
		sb.append("WHERE RR.ACTIVE_FLAG = 'Y' AND RR.REMITTANCE_REMARK_CD != ' '  ");
		sb.append("ORDER BY RR.REMITTANCE_REMARK_CD, RR.DESCRIPTION");
		
		remittanceRemarkList = jdbcTemplate.query(sb.toString(),
				new RowMapper<RemittanceRemark>() {

					@Override
					public RemittanceRemark mapRow(ResultSet rs, int rowNum) throws SQLException {

						RemittanceRemark remittanceRemark = new RemittanceRemark();
						remittanceRemark.setRemittanceRemarkCd(rs.getString("CODE"));
						remittanceRemark.setDescription(rs.getString("DESCRIPTION"));
						/*remittanceRemark.setFeeUsageFlag(rs.getString("FEE_USAGE_FLAG").charAt(0));
						remittanceRemark.setCreatedBy(rs.getString("CREATED_BY"));
						remittanceRemark.setDateCreated(rs.getDate("DATE_CREATED"));*/
						
						return remittanceRemark;
					}
				});

		return remittanceRemarkList;				
	}
}
