/**
 * 
 */
package gov.va.med.fee.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import gov.va.med.fee.dao.IAdditionalInfoRepositoryTemplate;
import gov.va.med.fee.model.response.ClaimPaymentResponse;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public class AdditionalInfoRepositoryTemplateImpl implements IAdditionalInfoRepositoryTemplate {

	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setJdbcTemplate(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fee.dao.IAdditionalInfoRepositoryTemplate#getAdditionalTabInfo(java.lang.Long)
	 */
	@Override
	public ClaimPaymentResponse getAdditionalTabInfo(Long claimIndex) {

		String sql = "select payment_tracking_number,  sum(paid_amount), trunc(treasury_payment_date) from claim_payment where claim_index = ? group by payment_tracking_number,trunc(treasury_payment_date)";
		ClaimPaymentResponse claimPaymentResponse = jdbcTemplate.query(sql, new Object[] { claimIndex },
				new ResultSetExtractor<ClaimPaymentResponse>() {

					@Override
					public ClaimPaymentResponse extractData(ResultSet rs) throws SQLException, DataAccessException {
						ClaimPaymentResponse claimPayment = null;
						while (rs.next()) {
							claimPayment = new ClaimPaymentResponse();
							claimPayment.setCheckNumber(rs.getString("PAYMENT_TRACKING_NUMBER"));
							claimPayment.setPaidAmountFormatted(rs.getBigDecimal("SUM(PAID_AMOUNT)"));
							claimPayment
									.setTreasuryPaymentDateFormatted(rs.getTimestamp("TRUNC(TREASURY_PAYMENT_DATE)"));
						}
						return claimPayment;
					}

				});

		return claimPaymentResponse;

	}

}
