package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.ZipCode;

@Repository
public interface IZipCodeRepository extends JpaRepository<ZipCode, Long> {

	@Query("select f from fZipCode f where f.zipCode = :zipCode")
	ZipCode findZipCodeByZipcode(@Param("zipCode") String zipCode);
	
	@Query("select f from fZipCode f JOIN FETCH f.vaFacility v where v.vaFacilityCd = :vaFac")
	List<ZipCode> findZipCodeByFacilityCd(@Param("vaFac") String vaFacilityCd);
	
	@Query("select count(*) from fZipCode f where f.zipCode = :zipCode")
	int checkZipCodeExists(@Param("zipCode") String zipCode);
	
}
