package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.Visn;

@Repository
public interface IVisnRepository extends JpaRepository<Visn, Long> {
	
	@Query("SELECT f.visnIdCd FROM fVisn f")
	List<Long> findAllVisnId();
	
	@Query("select v from fVisn v JOIN FETCH v.vaFacilities vf where v.visnIdCd = :visnNumber")
	Visn findAllVisn(@Param("visnNumber") Long visnNumber);
		
}
