/**
 * 
 */
package gov.va.med.fee.dao;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.PersonInfo;

/**
 * @author Vamsi Krishna Gangarapu
 * Repository layer for Veteran Information.
 * Query is to hit the Person_Info table with Claim number as an argument.
 *
 */
@Repository
public interface IVeteranInfoRepository extends JpaRepository<PersonInfo, Long> {

	/**
	 * @param claimIndex
	 * @return
	 */
	@Query("select p from fPersonInfo p JOIN p.claim c where c.claimIndex = :claimIndex")
	PersonInfo findOneByClaimId(@Param("claimIndex") Long claimIndex);
}
