package gov.va.med.fee.dao;

import java.util.List;

import gov.va.med.fee.model.request.VaFacilityRequest;
import gov.va.med.fee.model.request.VaFacilitySearchRequest;
import gov.va.med.fee.model.response.VaFacilityResponse;
import gov.va.med.fee.model.response.VaFacilityTypeResponse;
import gov.va.med.fee.model.response.VaFacilityVisnResponse;

public interface IVaFacilityRepositoryTemplate {

	public List<VaFacilityVisnResponse> getAllVisnsForFormLoad();

	public List<VaFacilityTypeResponse> getAllVaFacilityTypeForFormLoad();

	public int insertNewVaFacility(VaFacilityRequest addFacilityRequest);
	
	public int modifyVaFacility(VaFacilityRequest modifyFacilityRequest);
	
	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 */
	public List<VaFacilityResponse> getSearchResults(VaFacilitySearchRequest searchRequest);
	
	/**
	 * @author Vamsi Krishna Gangarapu
	 * 
	 */
	public Long getSearchResultsCount(VaFacilitySearchRequest searchRequest);
	
	public int checkVaFacility(String stationName);
}
