package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.VaFacility;

@Repository
public interface IVaFacilityRepository extends JpaRepository<VaFacility, Long> {

	@Query("select f from fVaFacility f where f.vaFacilityCd = :vaFac")
	VaFacility findVaFacilityByVaFacilityCd(@Param("vaFac") String vaFacilityCd);
	
	@Query("select f from fVaFacility f JOIN FETCH f.visn v JOIN FETCH f.vaFacilityType vf where f.vaFacilityCd = :vaFac")
	VaFacility findVaFacilityByStation(@Param("vaFac") String vaFacilityCd);
	
	@Query("select f from fVaFacility f JOIN FETCH f.contactInfos c JOIN FETCH f.zipCodes z where f.vaFacilityCd = :vaFac")
	VaFacility findVaFacility(@Param("vaFac") String vaFacilityCd);

	@Query(value = "select VA_FACILITY_CD from VA_FACILITY where VISN_ID_CD = :visnNum and VA_TYPE_CD ='FAC' and REROUTING_ALLOWED =1", nativeQuery = true)
	List<String> findFacilitiesList(@Param("visnNum") Long visnNum);
		
	@Query(value = "select * from VA_FACILITY where VISN_ID_CD = :visnNum and VA_TYPE_CD ='FAC' and VA_FACILITY_CD = :facilityId", nativeQuery = true)
	VaFacility findByVisnIdVaFacilityCd(@Param("visnNum") Long visnNum, @Param("facilityId") String facilityId);
	
	@Query("select f from fVaFacility f JOIN FETCH f.contactInfos c where f.vaFacilityCd = :vaFac")
	VaFacility findVaFacilityByContactInfo(@Param("vaFac") String vaFacilityCd);
	
	@Query("select f from fVaFacility f JOIN FETCH f.zipCodes z where f.vaFacilityCd = :vaFac")
	VaFacility findVaFacilityByZipCode(@Param("vaFac") String vaFacilityCd);
	
	@Query("select f from fVaFacility f JOIN FETCH f.claims c where f.vaFacilityCd = :vaFac")
	VaFacility findVisnBystationNumber(@Param("vaFac") String vaFacilityCd);
	
}
