package gov.va.med.fee.dao;

import java.util.List;

import gov.va.med.fee.model.request.UserSearchRequest;
import gov.va.med.fee.model.response.UserSearchResponse;

/**
 * This Spring Data JPA repository provides the methods to query Database to get one or more users by the search parameters
 * @author vhaisbjahank
 *
 */

public interface IUserSearchRepository {
	
	/**
	 * This method will be used to search for one of more users by search parameters
	 * @param userSearchRequest
	 * @return a list of UserSearchResponse
	 */
	List<UserSearchResponse> searchUsers(UserSearchRequest userSearchRequest);
}