package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.repository.query.Param;

import gov.va.med.domain.fee.AppUser;
import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.fee.model.request.StationRequest;
import gov.va.med.fee.model.request.UserReqRequest;
import gov.va.med.fee.model.response.UserRoles;

public interface IUserRequestRepositoryTemplate {

	public AppUserRequest findRequestByAppUserName(@Param("username") String userName);
		
	public List<UserRoles> getRolesForRequest();

	public List<StationRequest> getFacilitiesForRequest();
	
	/*Add new user request*/
	public int requestCreateUserRequest(UserReqRequest userReq, String appUserName);
		
	/*Modify user request*/
	public int requestModifyUserRequest(UserReqRequest userReq, String appUserName); 
	
	/*Find available facilities*/
	public List<StationRequest> getFacilitiesAvailableToUser();
	
	/*Find app user to be modified with appUserId*/
	public AppUser findRequestByAppUserId(Long appUserId);
	
	/*Find previously assigned roles for an app user with appUserId*/
	public List<UserRoles> findUserRolesForModify (Long appUserId) ;
	
	/*Find previously assigned facilities for an app user with appUserId*/
	public List<StationRequest> findUserFacilities (Long appUserId);
	
	public List<String> getRolesAvailableToUserForUserModifyRequest();
	
	public int deleteUserRequest(String appUserName);  //DELETE FROM APP_USER_REQUEST WHERE USER_NAME='DNS   DFGH';
}
