package gov.va.med.fee.dao;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.domain.fee.PrivacyToPerson;




/**
 * 
 * @author DNS   YIBRIK
 * email : yibriekedir@gmail.com
 *
 */
@Repository
public interface IPrivacyRestrictionRepo extends JpaRepository<PrivacyToPerson, Long> {
	
	/**
	 * 
	 * @param userName
	 * @param personId
	 * @param reason
	 * @param type
	 * @param appUser
	 * accepts these parameters and inserts to DB, \
	 */
	
	    @Modifying
	    @Query(value ="INSERT INTO "
		 		+ "fpps_owner.privacy_to_person "
		 		+ " (privacy_request_id"
		 		+ ", user_name, person_id,"
		 		+ " reason,"
		 		+ " request_type_flag,"
		 		+ " created_by, date_created) "
	            + " VALUES (fpps_owner.mig.nextval, :ntname, :ssn, :reason, :type, :appuser, sysdate)",nativeQuery=true)
	  
	    
	    
	    @Transactional
	    void addPrivacyRestriction(
	    		@Param("ntname") String userName,
	    		@Param("ssn") String personId,
	            @Param("reason") String reason,
		        @Param("type") String type,
		        @Param("appuser") String appUser
	    		);
	 

	@Query(value =" SELECT "
 			+ "c.claim_index " 
 			+ "FROM claims c, "
 			+ "person_info p "
            + " WHERE c.claim_index=p.claim_index "
            + " AND UPPER(c.user_name)=UPPER(:ntname) AND p.person_id=:ssn",nativeQuery=true)
	List<Integer> checkClaimAssociatedWithTheUser(@Param("ntname")String ntName , @Param("ssn")String ssn);
	
	
	@Query(value=" SELECT COUNT(*) FROM fpps_owner.privacy_to_person p "
                + " WHERE UPPER(p.user_name)=UPPER(:ntname) AND p.person_id=:ssn",nativeQuery=true)
	int checkPrivacyRestrictionExistanceInDB(@Param("ntname")String ntName , @Param("ssn")String ssn);

   }
	


