/**
 * 
 */
package gov.va.med.fee.dao;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.ProviderInfo;

/**
 * @author Vamsi Krishna Gangarapu
 * Repository layer for Pay to Provider and Service Provider Information.
 * Query is to hit the Provider_Type table with a claim number and Provider Type.
 *
 */
@Repository
public interface IPayToAndServiceProviderRepository extends JpaRepository<ProviderInfo, Long> {

	/**
	 * @param claimIndex
	 * @param providerType
	 * @return
	 */
	@Query("select p from fProviderInfo p JOIN p.providerType f JOIN p.claim c where f.providerTypeCd = :providerType and c.claimIndex = :claimIndex")
	ProviderInfo findOneByType(@Param("claimIndex") Long claimIndex, @Param("providerType") String providerType);
}
