/**
 * 
 */
package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.repository.query.Param;

import gov.va.med.fee.model.request.LineItemsRequest;
import gov.va.med.fee.model.request.SeqDetailRequest;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public interface ILineItemsRepositoryTemplate {

	/**
	 * @param claimIndex
	 * @return
	 */
	public List<LineItemsRequest> findLineItemsInfo(@Param("claimIndex") Long claimIndex);
	
	/**
	 * @param sequenceNumber
	 * @param claimIndex
	 * @return
	 */
	public SeqDetailRequest getCARCDetail(@Param("sequenceNumber") long sequenceNumber, @Param("claimIndex") long claimIndex);
	/**
	 * @param sequenceNumber
	 * @param claimIndex
	 * @return
	 */
	public List<SeqDetailRequest> getCAGCDetail(@Param("sequenceNumber") long sequenceNumber, @Param("claimIndex") long claimIndex);
	
	/**
	 * @param sequenceNumber
	 * @param claimIndex
	 * @return
	 */
	public List<SeqDetailRequest> getRARCDetail(@Param("sequenceNumber") long sequenceNumber, @Param("claimIndex") long claimIndex);
}
