package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.FeeClaimRoutingsReason;

@Repository
public interface IFeeClaimRoutingsReasonRepository extends JpaRepository<FeeClaimRoutingsReason, String> {

	@Query("select fcrr from fFeeClaimRoutingsReason fcrr order by fcrr.transferReasonCd asc")
	public List<FeeClaimRoutingsReason> getRerouteReasons();
	
	@Query("select fcrr from fFeeClaimRoutingsReason fcrr where fcrr.transferReasonCd= :transferReasonCd")
	public FeeClaimRoutingsReason getFeeClaimRoutingsReason(@Param("transferReasonCd") String transferReasonCd);
	
}


