package gov.va.med.fee.dao;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fee.model.response.AdjustmentReasonResponse;


/**
 * 
 * @author vhaisbjahank
 * 
 * This Spring Data JPA repository provides the methods to query Database to get all the distinct reason codes,
 * query the Database to get DisapproveClaim list, and 
 * update the all the related tables when user disapprove one or more claims
 * 
 * @Modifiedauthor: Vamsi Krishna Gangarapu
 * corrected populateAdjustmentReasons()
 * created getCount and updateWsFacStatus
 * 
 */

public interface IDisapproveClaimRepository {
	
	/**
	 *
	 * @return a list of reason codes as String type
	 */
	
	List<AdjustmentReasonResponse> populateAdjustmentReasons();

	BigDecimal getCount(Long claimId);
	
	Boolean updateWsFacStatusTable(Long claimId);
	Boolean updateWsFacStatusTable(List<Long> claimIdsList, String claimStatus);

}