/**
 * 
 */
package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.HealthcareInfoCode;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public interface IDiagnosisCodeRepository extends JpaRepository<HealthcareInfoCode, Long> {

	/**
	 * @param claimIndex
	 * @return
	 */
	@Query("select hi from fHealthcareInfoCode hi where hi.claim.claimIndex = :claimIndex and (hi.hi01cdListQual like 'BF%' or hi.hi01cdListQual like 'BK%' or hi.hi01cdListQual like 'PR%' or hi.hi01cdListQual like 'BN%' or hi.hi01cdListQual like 'BJ%' or hi.hi01cdListQual = 'ABF' or hi.hi01cdListQual = 'ABK' or hi.hi01cdListQual = 'APR' or hi.hi01cdListQual = 'ABN' or hi.hi01cdListQual = 'ABJ') order by hi.seqNbr")
	List<HealthcareInfoCode> findAllByClaim(@Param("claimIndex") Long claimIndex);
	
	/**
	 * @param claimIndex
	 * @return
	 */
	@Query("select hi FROM fHealthcareInfoCode hi WHERE hi.hi01cdListQual='DR' AND hi.claim.claimIndex = :claimIndex")
	HealthcareInfoCode findProviderDRGByClaim(@Param("claimIndex") Long claimIndex);
}
