/**
 * 
 */
package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import gov.va.med.domain.fee.ContactInfo;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public interface IContactInfoRepository extends JpaRepository<ContactInfo, Long> {

	@Query("select c from fContactInfo c JOIN FETCH c.vaFacility v where c.email = :email and v.vaFacilityCd = :vaFacilityCd")
	ContactInfo findOneByVaFacilityNameAndEmail(@Param("email") String email, @Param("vaFacilityCd") String vaFacilityCd);
	
	@Query("select c from fContactInfo c JOIN FETCH c.vaFacility v where c.contactInfoId = :contactInfoId and v.vaFacilityCd = :vaFacilityCd")
	ContactInfo findOneByVaFacilityName(@Param("contactInfoId") Long contactInfoId, @Param("vaFacilityCd") String vaFacilityCd);
	
	@Query("select c from fContactInfo c where c.contactInfoId = :contactInfoId")
	ContactInfo findOneBycontactInfoId(@Param("contactInfoId") Long contactInfoId);

	@Query("select c from fContactInfo c JOIN FETCH c.vaFacility v where v.vaFacilityCd = :vaFacilityCd")
	List<ContactInfo> findContactInfo(@Param("vaFacilityCd") String vaFacilityCd);
	
	@Query("select c from fContactInfo c JOIN FETCH c.vaFacility v where c.contactInfoId = :contactInfoId and v.vaFacilityCd = :vaFacilityCd")
	ContactInfo findOneByVaFacilityNameAndcontactInfoId(@Param("contactInfoId") Long contactInfoId, @Param("vaFacilityCd") String vaFacilityCd);
}
