package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.Claim;

/**
 * @author Eyuel Taddese
 *This spring data jpa repository provides the methods to query the claim data from the database.
 *
 */

@Repository
public interface IClaimRepository extends JpaRepository<Claim,Long> {
	
	/**
	 * @author Vamsi Krishna Gangarapu
	 * @param claimIndex
	 * @return claim
	 */
	@Query("select c from fClaim c JOIN FETCH c.serviceType s where c.claimIndex = :claimIndex")
	Claim findByClaimIndex(@Param("claimIndex") Long claimIndex);
	
	/**
	 * @author Vamsi Krishna Gangarapu
	 * @param claimIndex
	 * @return Claim
	 */
	@Query("select c from fClaim c where c.claimIndex = :claimIndex")
	Claim findClaimByClaimIndex(@Param("claimIndex") Long claimIndex);
	
	@Query("select c from fClaim c JOIN FETCH c.providerInfos p JOIN FETCH c.personInfos pe where c.claimIndex = :claimIndex")
	Claim findClaimStatusByClaimIndex(@Param("claimIndex") Long claimIndex);
	
	@Query("select c from fClaim c JOIN FETCH c.claimQueues cq where c.claimIndex = :claimIndex")
	Claim findClaimQueueByClaimIndex(@Param("claimIndex") Long claimIndex);
	
	/*@Query("select c from fClaim c where c.claimIndex in :claimIndexes")
	List<Claim>findAll(@Param("claimIndexes") Iterable<Long> claimIndexes);*/

}