/**
 * 
 */
package gov.va.med.fee.dao;

import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.ClaimQueue;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public interface IClaimQueueRepository extends JpaRepository<ClaimQueue, Long> {
	
	@Query("select cq from fClaimQueue cq JOIN FETCH cq.claim c where cq.claim = :claimIndex")
	ClaimQueue findClaimByClaimIndex(@Param("claimIndex") Long claimIndex);
	
	@Query("select cq from fClaimQueue cq where cq.claim in :claimIndexes and cq.dequeueDate is null and cq.claimQueueTypeCd = 'REJECTION_APPROVAL'")
	ClaimQueue findClaimQueues(@Param("claimIndexes") List<Long> inventoryIdList);
	
	@Query(value = "select cq.*, c.* " + 
			"from claim_queue cq inner join       " + 
			"  (Select cq.claim_index, MAX(cq.CLAIM_QUEUE_ID)as maxQueueId       " + 
			"  from claim_queue cq       " + 
			"  Group by claim_index) maxClaimQ  " + 
			"on cq.claim_index = maxClaimQ.claim_index  " + 
			"and cq.CLAIM_QUEUE_ID=maxClaimQ.maxQueueId  " + 
			"inner join claims c on c.claim_index = maxClaimQ.claim_index  " + 
			"and cq.claim_index in :claimIndexes " + 
			"and cq.claim_queue_type_cd = 'REJECTION_APPROVAL'  " + 
			"and cq.dequeue_date is null  " + 
			"order by cq.enqueue_date desc ", nativeQuery = true)
	List<ClaimQueue> findRejectedClaimQueue(@Param("claimIndexes") Set<Long> claimIndexes);
	
}
