package gov.va.med.fee.dao;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.ClaimProcedure;

@Repository
public interface IClaimProcedureRepository extends JpaRepository<ClaimProcedure, Long> {

	@Query("select cp from fClaimProcedure cp where cp.claim.claimIndex = :claimIndex")
	public List<ClaimProcedure> findClaimProcedure(@Param("claimIndex") Long claimIndex);
	
	@Query(value = "select billed_amount from claim_procedure where claim_proc_id = :id", nativeQuery = true)
	public BigDecimal getBilledAmount(@Param("id") Long claimProcId);
}
